/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.entities;

import eu.dnetlib.uoausermanagment.entities.ZombieUser;
import java.util.List;
import javax.naming.Name;
import org.springframework.data.domain.Persistable;
import org.springframework.ldap.odm.annotations.Attribute;
import org.springframework.ldap.odm.annotations.Entry;
import org.springframework.ldap.odm.annotations.Id;
import org.springframework.ldap.odm.annotations.Transient;
import org.springframework.ldap.support.LdapUtils;

@Entry(base="ou=users", objectClasses={"inetOrgPerson", "eduPerson"})
public class User
implements Persistable<Name> {
    @Id
    private Name dn;
    @Attribute(name="uid")
    private String username;
    @Attribute(name="cn")
    private String commonName;
    @Attribute(name="sn")
    private String surname;
    @Attribute(name="givenName")
    private String givenName;
    @Attribute(name="mail")
    private String email;
    @Attribute(name="eduPersonPrincipalName")
    private String eduPersonPrincipalName;
    @Attribute(name="displayName")
    private String displayName;
    @Attribute(name="o")
    private String organization;
    @Attribute(name="userPassword")
    private String userPassword;
    @Attribute(name="objectClass")
    private List<String> objectClass;
    @Transient
    private boolean isNew;

    public User() {
    }

    public User(ZombieUser user) {
        this.dn = LdapUtils.newLdapName((String)("uid=" + user.getUsername() + ",ou=users"));
        this.commonName = this.username = user.getUsername();
        this.givenName = user.getGivenName();
        this.surname = user.getSurname();
        this.displayName = user.getDisplayName();
        this.organization = user.getOrganization();
        this.email = user.getEmail();
        this.eduPersonPrincipalName = user.getEduPersonPrincipalName();
        this.userPassword = user.getStoredPassword();
        this.objectClass = user.getObjectClass();
        this.isNew = true;
    }

    public Name getDn() {
        return this.dn;
    }

    public void setDn(Name dn) {
        this.dn = dn;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEduPersonPrincipalName() {
        return this.eduPersonPrincipalName;
    }

    public void setEduPersonPrincipalName(String eduPersonPrincipalName) {
        this.eduPersonPrincipalName = eduPersonPrincipalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public List<String> getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(List<String> objectClass) {
        this.objectClass = objectClass;
    }

    public Name getId() {
        return this.getDn();
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }
}

