/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import org.springframework.security.crypto.password.PasswordEncoder;

public class SSHAEncoder
implements PasswordEncoder {
    private static final int SALT_LENGTH = 4;

    public String encode(CharSequence rawPassword) {
        try {
            SecureRandom random = new SecureRandom();
            byte[] salt = new byte[4];
            random.nextBytes(salt);
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            sha1.update(rawPassword.toString().getBytes(StandardCharsets.UTF_8));
            sha1.update(salt);
            byte[] hashedBytes = sha1.digest();
            byte[] hashWithSalt = new byte[hashedBytes.length + salt.length];
            System.arraycopy(hashedBytes, 0, hashWithSalt, 0, hashedBytes.length);
            System.arraycopy(salt, 0, hashWithSalt, hashedBytes.length, salt.length);
            return "{SSHA}" + Base64.getEncoder().encodeToString(hashWithSalt);
        }
        catch (Exception e) {
            throw new RuntimeException("Error encoding password", e);
        }
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(encodedPassword.substring(6));
            byte[] salt = Arrays.copyOfRange(decodedBytes, 20, decodedBytes.length);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(rawPassword.toString().getBytes(StandardCharsets.UTF_8));
            md.update(salt);
            byte[] hashedBytes = md.digest();
            return MessageDigest.isEqual(hashedBytes, Arrays.copyOfRange(decodedBytes, 0, 20));
        }
        catch (Exception e) {
            throw new RuntimeException("Error matching password", e);
        }
    }
}

