/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.services;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.HttpException;
import eu.dnetlib.uoausermanagment.configuration.Google;
import eu.dnetlib.uoausermanagment.configuration.Mail;
import eu.dnetlib.uoausermanagment.configuration.Properties;
import eu.dnetlib.uoausermanagment.dto.Email;
import eu.dnetlib.uoausermanagment.dto.GoogleResponse;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class UtilsService {
    private static final Logger logger = LogManager.getLogger(UtilsService.class);
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("[A-Za-z0-9_-]+");
    private final JavaMailSender mailSender;
    private final Mail mail;
    private final Google google;
    private final RestTemplate restTemplate;

    @Autowired
    public UtilsService(JavaMailSender mailSender, Properties properties, RestTemplate restTemplate) {
        this.mailSender = mailSender;
        this.mail = properties.getMail();
        this.google = properties.getGoogle();
        this.restTemplate = restTemplate;
    }

    public void send(Email email) {
        logger.debug("Try to connect to mail sender with {}", (Object)this.mail.getUsername());
        try {
            logger.debug("Try to sent e-mail to {}\nSubject: {}\nBody:{}", (Object)email.getRecipient(), (Object)email.getSubject(), (Object)email.getBody());
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(new InternetAddress(this.mail.getFrom()));
            ArrayList<String> bccRecipients = new ArrayList<String>(Collections.singletonList(this.mail.getFrom()));
            helper.setTo(email.getRecipient());
            helper.setBcc(bccRecipients.toArray(new String[0]));
            helper.setSubject(email.getSubject());
            helper.setText(email.getBody(), true);
            this.mailSender.send(message);
            logger.debug("Sent message successfully....\n");
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    public boolean processResponse(String response) {
        if (!this.responseSanityCheck(response)) {
            throw new RuntimeException("Response contains invalid characters");
        }
        URI verifyUri = URI.create(String.format("https://www.google.com/recaptcha/api/siteverify?secret=%s&response=%s", this.google.getSecret(), response));
        GoogleResponse googleResponse = (GoogleResponse)this.restTemplate.getForObject(verifyUri, GoogleResponse.class);
        assert (googleResponse != null);
        if (!googleResponse.isSuccess()) {
            logger.error("Has client error: {}", (Object)googleResponse.hasClientError());
            throw new RuntimeException("ReCaptcha was not successfully validated");
        }
        return googleResponse.isSuccess();
    }

    private boolean responseSanityCheck(String response) {
        return StringUtils.hasLength((String)response) && RESPONSE_PATTERN.matcher(response).matches();
    }
}

