/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.configuration;

import eu.dnetlib.uoausermanagment.configuration.LDAP;
import eu.dnetlib.uoausermanagment.configuration.Properties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@Profile(value={"html"})
public class LDAPConfig {
    private final LDAP ldap;

    public LDAPConfig(Properties properties) {
        this.ldap = properties.getLdap();
    }

    public LdapContextSource ldapContextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldap.getAddress() + ":" + this.ldap.getPort());
        contextSource.setBase(this.ldap.getBaseDN());
        contextSource.setUserDn(this.ldap.getAdminDN());
        contextSource.setPassword(this.ldap.getPassword());
        contextSource.afterPropertiesSet();
        return contextSource;
    }

    @Bean
    public LdapTemplate ldapTemplate() {
        return new LdapTemplate((ContextSource)this.ldapContextSource());
    }
}

