/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.controllers;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ConflictException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoausermanagment.dto.EmailDetails;
import eu.dnetlib.uoausermanagment.dto.Invitation;
import eu.dnetlib.uoausermanagment.dto.Result;
import eu.dnetlib.uoausermanagment.dto.StringResult;
import eu.dnetlib.uoausermanagment.dto.UserDetails;
import eu.dnetlib.uoausermanagment.entities.RoleVerification;
import eu.dnetlib.uoausermanagment.entities.VerificationType;
import eu.dnetlib.uoausermanagment.services.RoleManagementService;
import eu.dnetlib.uoausermanagment.services.RoleVerificationService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/registry"})
@Profile(value={"registry"})
public class RegistryController {
    private final RoleManagementService roleManagementService;
    private final AuthorizationService authorizationService;
    private final RoleVerificationService roleVerificationService;

    @Autowired
    public RegistryController(RoleManagementService roleManagementService, AuthorizationService authorizationService, RoleVerificationService roleVerificationService) {
        this.roleManagementService = roleManagementService;
        this.authorizationService = authorizationService;
        this.roleVerificationService = roleVerificationService;
    }

    @RequestMapping(value={"/subscribe/{type}/{id}"}, method={RequestMethod.POST})
    @PreAuthorize(value="isAuthenticated() and #type.equals('community')")
    public ResponseEntity<StringResult> subscribe(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.roleManagementService.assignMemberRole(type, id, request));
    }

    @RequestMapping(value={"/unsubscribe/{type}/{id}"}, method={RequestMethod.POST})
    @PreAuthorize(value="isAuthenticated() and #type.equals('community')")
    public ResponseEntity<StringResult> unsubscribe(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.roleManagementService.removeMemberRole(type, id, request));
    }

    @RequestMapping(value={"/create/{type}"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    public ResponseEntity<StringResult> createCuratorRole(HttpServletRequest request, @PathVariable(value="type") String type) {
        return ResponseEntity.ok((Object)this.roleManagementService.createCuratorRole(type, request));
    }

    @RequestMapping(value={"/create/{type}/{id}"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type))")
    public ResponseEntity<List<StringResult>> createMemberRole(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.roleManagementService.createMemberRole(type, id, request));
    }

    @RequestMapping(value={"/invite/{type}/{id}/manager"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public ResponseEntity<Result<Invitation>> inviteManager(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestBody EmailDetails details) {
        if (!this.roleManagementService.isManager(type, id, details.getEmail().getRecipient(), request)) {
            return ResponseEntity.ok((Object)new Result(this.authorizationService.manager(type, id), (Object)this.roleVerificationService.inviteManager(details, type, id)));
        }
        throw new ConflictException("User has been already manager of this " + type);
    }

    @RequestMapping(value={"/invite/{type}/{id}/member"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public ResponseEntity<Result<Invitation>> inviteMember(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestBody EmailDetails details) {
        if (!this.roleManagementService.isMember(type, id, details.getEmail().getRecipient(), request)) {
            return ResponseEntity.ok((Object)new Result(this.authorizationService.member(type, id), (Object)this.roleVerificationService.inviteMember(details, type, id)));
        }
        throw new ConflictException("User has been already member of this " + type);
    }

    @RequestMapping(value={"/invite/{type}/{id}/manager/{email}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public ResponseEntity<StringResult> cancelManagerInvitations(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @PathVariable(value="email") String email) {
        this.roleVerificationService.cancelManagerInvitation(type, id, email);
        return ResponseEntity.ok((Object)new StringResult(this.authorizationService.manager(type, id), "Invitations have been deleted"));
    }

    @RequestMapping(value={"/invite/{type}/{id}/member/{email}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public ResponseEntity<StringResult> cancelMemberInvitations(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @PathVariable(value="email") String email) {
        this.roleVerificationService.cancelMemberInvitation(type, id, email);
        return ResponseEntity.ok((Object)new StringResult(this.authorizationService.member(type, id), "Invitations have been deleted"));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    @RequestMapping(value={"/invite/{type}/{id}/managers"}, method={RequestMethod.GET})
    public ResponseEntity<Result<List<String>>> getInvitedManagers(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)new Result(this.authorizationService.manager(type, id), (Object)this.roleVerificationService.getInvitedManagers(type, id)));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    @RequestMapping(value={"/invite/{type}/{id}/members"}, method={RequestMethod.GET})
    public ResponseEntity<Result<List<String>>> getInviteMembers(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)new Result(this.authorizationService.member(type, id), (Object)this.roleVerificationService.getInvitedMembers(type, id)));
    }

    @PreAuthorize(value="@Verification.isMyVerification(#id)")
    @RequestMapping(value={"/verification/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Result<RoleVerification>> getVerification(@PathVariable(value="id") String id) {
        RoleVerification roleVerification = this.roleVerificationService.getRoleVerification(id);
        if (roleVerification.getVerificationType().equals((Object)VerificationType.MANAGER)) {
            return ResponseEntity.ok((Object)new Result(this.authorizationService.manager(roleVerification.getType(), roleVerification.getEntity()), (Object)roleVerification));
        }
        return ResponseEntity.ok((Object)new Result(this.authorizationService.member(roleVerification.getType(), roleVerification.getEntity()), (Object)roleVerification));
    }

    @PreAuthorize(value="@Verification.isMyVerification(#id)")
    @RequestMapping(value={"/verification/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<StringResult> deleteVerification(@PathVariable(value="id") String id) {
        String role = this.roleVerificationService.getRoleFromVerification(id);
        this.roleVerificationService.deleteVerification(id);
        return ResponseEntity.ok((Object)new StringResult(role, "Verification deleted"));
    }

    @PreAuthorize(value="@Verification.isMyManagerVerification(#id)")
    @RequestMapping(value={"/verification/manager/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<StringResult> verifyManager(HttpServletRequest request, @PathVariable(value="id") String id, @RequestBody String code) {
        RoleVerification verification = this.roleVerificationService.getRoleVerification(id);
        this.roleVerificationService.verify(id, code);
        this.roleManagementService.assignManagerRole(verification.getType(), verification.getEntity(), request);
        if (this.roleVerificationService.isCommunity(verification.getType())) {
            this.roleManagementService.assignMemberRole("ri", verification.getEntity(), request);
        }
        this.roleVerificationService.cancelAllInvitation(verification.getType(), verification.getEntity(), verification.getEmail());
        return ResponseEntity.ok((Object)new StringResult(this.authorizationService.manager(verification.getType(), verification.getEntity()), "Role has been assigned"));
    }

    @PreAuthorize(value="@Verification.isMyMemberVerification(#id)")
    @RequestMapping(value={"/verification/member/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<StringResult> verifyMember(HttpServletRequest request, @PathVariable(value="id") String id, @RequestBody String code) {
        RoleVerification verification = this.roleVerificationService.getRoleVerification(id);
        this.roleVerificationService.verify(id, code);
        this.roleManagementService.assignMemberRole(verification.getType(), verification.getEntity(), request);
        this.roleVerificationService.cancelMemberInvitation(verification.getType(), verification.getEntity(), verification.getEmail());
        return ResponseEntity.ok((Object)new StringResult(this.authorizationService.member(verification.getType(), verification.getEntity()), "Role has been assigned"));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    @RequestMapping(value={"/{type}/{id}/manager/{email}"}, method={RequestMethod.DELETE})
    public ResponseEntity<StringResult> removeManagerRole(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id, @PathVariable(value="email") String email) {
        return ResponseEntity.ok((Object)this.roleManagementService.removeManagerRole(type, id, email, request));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    @RequestMapping(value={"/{type}/{id}/member/{email}"}, method={RequestMethod.DELETE})
    public ResponseEntity<StringResult> removeMemberRole(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id, @PathVariable String email) {
        return ResponseEntity.ok((Object)this.roleManagementService.removeMemberRole(type, id, email, request));
    }

    @RequestMapping(value={"/{type}/{id}/members/count"}, method={RequestMethod.GET})
    public ResponseEntity<Result<Integer>> getMembersCount(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)new Result(this.authorizationService.member(type, id), (Object)this.roleManagementService.getAllMembersCount(type, id, request)));
    }

    @RequestMapping(value={"/{type}/{id}/members"}, method={RequestMethod.GET})
    public ResponseEntity<Result<UserDetails[]>> getMembers(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)new Result(this.authorizationService.member(type, id), (Object)this.roleManagementService.getAllMembers(type, id, request)));
    }

    @RequestMapping(value={"/{type}/{id}/managers"}, method={RequestMethod.GET})
    public ResponseEntity<Result<UserDetails[]>> getManagers(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)new Result(this.authorizationService.manager(type, id), (Object)this.roleManagementService.getAllManagers(type, id, request)));
    }

    @RequestMapping(value={"/{type}/curators"}, method={RequestMethod.GET})
    public ResponseEntity<Result<UserDetails[]>> getCurators(HttpServletRequest request, @PathVariable(value="type") String type) {
        return ResponseEntity.ok((Object)new Result(this.authorizationService.curator(type), (Object)this.roleManagementService.getAllCurators(type, request)));
    }
}

