/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.services;

import eu.dnetlib.uoausermanagment.configuration.Datasource;
import eu.dnetlib.uoausermanagment.configuration.GlobalVars;
import eu.dnetlib.uoausermanagment.configuration.Google;
import eu.dnetlib.uoausermanagment.configuration.LDAP;
import eu.dnetlib.uoausermanagment.configuration.Mail;
import eu.dnetlib.uoausermanagment.configuration.Properties;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class DeployService {
    private final Datasource datasource;
    private final String developers;
    private final String developersApi;
    private final String loginUrl;
    private final String roleManagement;
    private final Mail mail;
    private final Google google;
    private final LDAP ldap;
    private final GlobalVars globalVars;
    private final List<String> profiles;

    @Autowired
    public DeployService(Properties properties, GlobalVars globalVars, Environment environment) {
        this.datasource = properties.getDatasource();
        this.developers = properties.getDevelopers();
        this.developersApi = properties.getDevelopersApi();
        this.loginUrl = properties.getLoginUrl();
        this.roleManagement = properties.getRoleManagement();
        this.mail = properties.getMail();
        this.google = properties.getGoogle();
        this.ldap = properties.getLdap();
        this.globalVars = globalVars;
        this.profiles = Arrays.asList(environment.getActiveProfiles());
    }

    @PostConstruct
    public void checkProperties() {
        if (!this.profiles.contains("html") && !this.profiles.contains("registry")) {
            throw new RuntimeException("You need to specify at least one profile (html, registry)");
        }
        if (this.datasource.getUrl() == null || this.datasource.getUrl().isEmpty()) {
            throw new RuntimeException("user-management.datasource.url is missing!");
        }
        if (this.mail.getHost() == null || this.mail.getHost().isEmpty()) {
            throw new RuntimeException("user-management.mail.host is missing!");
        }
        if (this.mail.getPort() == null || this.mail.getPort().isEmpty()) {
            throw new RuntimeException("user-management.mail.port is missing!");
        }
        if (this.mail.getFrom() == null || this.mail.getFrom().isEmpty()) {
            throw new RuntimeException("user-management.mail.from is missing!");
        }
        if (this.mail.getProtocol() == null || this.mail.getProtocol().isEmpty()) {
            throw new RuntimeException("user-management.mail.protocol is missing!");
        }
        if (this.mail.getDefaultEncoding() == null || this.mail.getDefaultEncoding().isEmpty()) {
            throw new RuntimeException("user-management.datasource.defaultEncoding is missing!");
        }
        if (this.mail.getAuth() == null || this.mail.getAuth().isEmpty()) {
            throw new RuntimeException("user-management.mail.auth is missing!");
        }
        if (Boolean.parseBoolean(this.mail.getAuth()) && (this.mail.getUsername() == null || this.mail.getUsername().isEmpty())) {
            throw new RuntimeException("user-management.mail.username is missing!");
        }
        if (Boolean.parseBoolean(this.mail.getAuth()) && (this.mail.getPassword() == null || this.mail.getPassword().isEmpty())) {
            throw new RuntimeException("user-management.mail.password is missing!");
        }
        if (this.profiles.contains("html")) {
            if (this.developers == null || this.developers.isEmpty()) {
                throw new RuntimeException("user-management.developers is missing!");
            }
            if (this.developersApi == null || this.developersApi.isEmpty()) {
                throw new RuntimeException("user-management.developers-api is missing!");
            }
            if (this.loginUrl == null || this.loginUrl.isEmpty()) {
                throw new RuntimeException("user-management.login-url is missing!");
            }
            if (this.google.getKey() == null || this.google.getKey().isEmpty()) {
                throw new RuntimeException("user-management.google.key is missing!");
            }
            if (this.google.getSecret() == null || this.google.getSecret().isEmpty()) {
                throw new RuntimeException("user-management.google.secret is missing!");
            }
            if (this.ldap.getAddress() == null || this.ldap.getAddress().isEmpty()) {
                throw new RuntimeException("user-management.ldap.address is missing!");
            }
            if (this.ldap.getBaseDN() == null || this.ldap.getBaseDN().isEmpty()) {
                throw new RuntimeException("user-management.ldap.baseDN is missing!");
            }
            if (this.ldap.getAdminDN() == null || this.ldap.getAdminDN().isEmpty()) {
                throw new RuntimeException("user-management.ldap.adminDN is missing!");
            }
            if (this.ldap.getPassword() == null || this.ldap.getPassword().isEmpty()) {
                throw new RuntimeException("user-management.ldap.password is missing!");
            }
            if (this.ldap.getPort() == null || this.ldap.getPort().isEmpty()) {
                throw new RuntimeException("user-management.ldap.port is missing!");
            }
        }
        if (this.profiles.contains("registry") && (this.roleManagement == null || this.roleManagement.isEmpty())) {
            throw new RuntimeException("user-management.role-management is missing!");
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("user-management.role-management", this.roleManagement);
        response.put("user-management.developers", this.developers);
        response.put("user-management.developers-api", this.developersApi);
        response.put("user-management.login-url", this.loginUrl);
        response.put("user-management.datasource.url", this.datasource.getUrl());
        response.put("user-management.datasource.username", this.datasource.getUsername());
        response.put("user-management.datasource.password", this.datasource.getPassword());
        response.put("user-management.mail.auth", this.mail.getAuth());
        response.put("user-management.mail.sslProtocols", this.mail.getSslProtocols());
        response.put("user-management.mail.from", this.mail.getFrom());
        response.put("user-management.mail.host", this.mail.getHost());
        response.put("user-management.mail.port", this.mail.getPort());
        response.put("user-management.mail.username", this.mail.getUsername());
        response.put("user-management.mail.password", this.mail.getPassword());
        response.put("user-management.google.key", this.google.getKey());
        response.put("user-management.google.secret", this.google.getSecret());
        response.put("user-management.ldap.address", this.ldap.getAddress());
        response.put("user-management.ldap.baseDN", this.ldap.getBaseDN());
        response.put("user-management.ldap.adminDN", this.ldap.getAdminDN());
        response.put("user-management.ldap.password", this.ldap.getPassword());
        response.put("user-management.ldap.port", this.ldap.getPort());
        response.put("Date of deploy", GlobalVars.date.toString());
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

