/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.dto.form;

import eu.dnetlib.uoausermanagment.dto.form.Form;
import eu.dnetlib.uoausermanagment.entities.AccountStatus;
import eu.dnetlib.uoausermanagment.services.LDAPService;
import eu.dnetlib.uoausermanagment.services.ValidationService;
import org.springframework.ui.Model;

public class RequestByUsernameForm
extends Form {
    protected boolean shouldActivate = false;

    public boolean validate(LDAPService ldapService, ValidationService validationService, Model model, String recaptchaResponse) {
        Object usernameError = validationService.validateRequired(this.username, "Please enter your username");
        if (usernameError == null) {
            if (!ldapService.usernameExists(this.username)) {
                usernameError = "Username " + this.username + " does not exist";
            } else if (!this.shouldActivate && ldapService.accountStatus(this.username).equals((Object)AccountStatus.ACTIVATED)) {
                usernameError = "User with username " + this.username + " is already activated";
            } else if (this.shouldActivate && !ldapService.accountStatus(this.username).equals((Object)AccountStatus.ACTIVATED)) {
                usernameError = "User with username " + this.username + " is not activated";
            }
        }
        model.addAttribute("username_error", usernameError);
        String recaptchaError = validationService.validateRecaptcha(recaptchaResponse);
        model.addAttribute("recaptcha_error", (Object)recaptchaError);
        return usernameError == null && recaptchaError == null;
    }
}

