/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.uoausermanagment.dao.RoleVerificationDAO;
import eu.dnetlib.uoausermanagment.entities.VerificationType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Random;

@Entity
public class RoleVerification {
    private static final Random random = new Random();
    @Id
    private String id;
    private String email;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String verificationCode;
    @Enumerated(value=EnumType.STRING)
    private VerificationType verificationType;
    private String type;
    private String entity;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;

    public RoleVerification() {
    }

    public RoleVerification(RoleVerificationDAO dao, String email, VerificationType verificationType, String type, String entity) {
        do {
            this.id = this.createId();
        } while (dao.existsById((Object)this.id));
        this.email = email;
        this.verificationCode = this.createVerificationCode();
        this.verificationType = verificationType;
        this.type = type;
        this.entity = entity;
        this.date = new Date();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public VerificationType getVerificationType() {
        return this.verificationType;
    }

    public void setVerificationType(VerificationType verificationType) {
        this.verificationType = verificationType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    private String createId() {
        return random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private String createVerificationCode() {
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            code.append(random.nextInt(9));
        }
        return code.toString();
    }
}

