/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.services;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoausermanagment.configuration.Properties;
import eu.dnetlib.uoausermanagment.dto.StringResult;
import eu.dnetlib.uoausermanagment.dto.UserDetails;
import eu.dnetlib.uoausermanagment.services.HttpService;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
@Profile(value={"registry"})
public class RoleManagementService {
    private static final Logger logger = LogManager.getLogger(RoleManagementService.class);
    private final HttpService httpService;
    private final String url;
    private final AuthorizationService authorizationService;

    private String mapType(String type, boolean communityMap) {
        if (type.equals("organization")) {
            type = "institution";
        } else if (type.equals("ri") && communityMap) {
            type = "community";
        }
        return type;
    }

    @Autowired
    public RoleManagementService(HttpService httpService, Properties properties, AuthorizationService authorizationService) {
        this.httpService = httpService;
        this.url = properties.getRoleManagement();
        this.authorizationService = authorizationService;
    }

    public StringResult assignMemberRole(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force", "true");
        return this.httpService.post(request, this.url + "/member/" + this.mapType(type, false) + "/" + id, null, params);
    }

    public StringResult assignManagerRole(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force", "true");
        return this.httpService.post(request, this.url + "/admin/" + this.mapType(type, true) + "/" + id, null, params);
    }

    public StringResult removeMemberRole(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force", "true");
        return this.httpService.delete(request, this.url + "/member/" + this.mapType(type, false) + "/" + id, params);
    }

    public StringResult removeMemberRole(String type, String id, String email, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        return this.httpService.delete(request, this.url + "/member/" + this.mapType(type, false) + "/" + id, params);
    }

    public StringResult removeManagerRole(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        return this.httpService.delete(request, this.url + "/admin/" + this.mapType(type, true) + "/" + id, null);
    }

    public StringResult removeManagerRole(String type, String id, String email, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        return this.httpService.delete(request, this.url + "/admin/" + this.mapType(type, true) + "/" + id, params);
    }

    public UserDetails[] getAllMembers(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        return (UserDetails[])this.httpService.get(request, this.url + "/member/" + this.mapType(type, false) + "/" + id, null, UserDetails[].class);
    }

    public Integer getAllMembersCount(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        return (Integer)this.httpService.get(request, this.url + "/member/" + this.mapType(type, false) + "/" + id + "/count", null, Integer.class);
    }

    public UserDetails[] getAllManagers(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!(this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(type) || this.authorizationService.isManager(type, id))) {
            params.put("name", "false");
            params.put("email", "false");
        }
        return (UserDetails[])this.httpService.get(request, this.url + "/admin/" + this.mapType(type, true) + "/" + id, params, UserDetails[].class);
    }

    public UserDetails[] getAllCurators(String type, HttpServletRequest request) throws HttpClientErrorException {
        return (UserDetails[])this.httpService.get(request, this.url + "/curator/" + this.mapType(type, false), null, UserDetails[].class);
    }

    public boolean isMember(String type, String id, String email, HttpServletRequest request) throws HttpClientErrorException {
        for (UserDetails userDetails : this.getAllMembers(type, id, request)) {
            if (!userDetails.getEmail().equalsIgnoreCase(email)) continue;
            return true;
        }
        return false;
    }

    public boolean isManager(String type, String id, String email, HttpServletRequest request) throws HttpClientErrorException {
        for (UserDetails userDetails : this.getAllManagers(type, id, request)) {
            if (!userDetails.getEmail().equalsIgnoreCase(email)) continue;
            return true;
        }
        return false;
    }

    public List<StringResult> createMemberRole(String type, String id, HttpServletRequest request) {
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("description", (CallSite)((Object)(this.mapType(type, false) + " " + id)));
        String[] types = new String[]{type};
        if (type.equals("ri") || type.equals("community")) {
            types = new String[]{"ri", "community"};
        }
        return Arrays.stream(types).map(t -> this.httpService.post(request, this.url + "/member/" + this.mapType(t, false) + "/" + id + "/create", null, params)).toList();
    }

    public StringResult createCuratorRole(String type, HttpServletRequest request) {
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("description", (CallSite)((Object)(this.mapType(type, false) + " Curator")));
        return this.httpService.post(request, this.url + "/curator/" + this.mapType(type, false) + "/create", null, params);
    }

    public StringResult createRole(String name, String description, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        params.put("description", description);
        return this.httpService.post(request, this.url + "/super/create", null, params);
    }
}

