/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.services;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.HttpException;
import eu.dnetlib.uoausermanagment.dao.UserVerificationDAO;
import eu.dnetlib.uoausermanagment.dto.Email;
import eu.dnetlib.uoausermanagment.entities.UserVerification;
import eu.dnetlib.uoausermanagment.services.UtilsService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
@Profile(value={"html"})
public class UserVerificationService {
    private final UserVerificationDAO dao;
    private final UtilsService utilsService;

    @Autowired
    public UserVerificationService(UserVerificationDAO dao, UtilsService utilsService) {
        this.dao = dao;
        this.utilsService = utilsService;
    }

    public UserVerification create(String username) {
        UserVerification verification = this.dao.findByUsername(username).orElseGet(() -> new UserVerification(username));
        verification.updateVerificationCode();
        return (UserVerification)this.dao.save((Object)verification);
    }

    public String validate(HttpServletRequest request, Model model, String username, String verificationCode, String path) {
        UserVerification verification = this.dao.findByUsernameAndVerificationCode(username, verificationCode).orElse(null);
        if (verification == null) {
            model.addAttribute("server_error", (Object)"Username or verification code are not valid.");
            return path;
        }
        if (verification.expired()) {
            request.getSession().setAttribute("expired", (Object)true);
            return "redirect:/expired";
        }
        this.dao.delete((Object)verification);
        return null;
    }

    public String createURL(HttpServletRequest request, String path, String params) {
        return request.getScheme() + "://" + request.getServerName() + (String)(request.getServerPort() != 80 && request.getServerPort() != 443 ? ":" + request.getServerPort() : "") + request.getContextPath() + "/" + path + params;
    }

    public void sendActivationVerification(HttpServletRequest request, Model model, UserVerification verification, String userEmail) {
        String url = this.createURL(request, "activate", "?code=" + verification.getVerificationCode());
        Email email = new Email();
        email.setBody("<p>Hello " + verification.getUsername() + ",</p><p> A request has been made to verify your email and activate your OpenAIRE account. To activate your account, you will need to submit your username and this activation code in order to verify that the request was legitimate.</p><p>The activation code is " + verification.getVerificationCode() + "</p>Click the URL below and proceed with activating your password.<p><a href=" + url + ">" + url + "</a></p><p>The activation code is valid for 24 hours.</p><p>Thank you,</p><p>OpenAIRE technical team</p>");
        email.setSubject("Activate your OpenAIRE account");
        email.setRecipient(userEmail);
        try {
            this.utilsService.send(email);
        }
        catch (HttpException e) {
            model.addAttribute("server_error", (Object)"Email sent failed");
        }
    }

    public void sendVerificationToDelete(HttpServletRequest request, Model model, UserVerification verification, String userEmail) {
        String url = this.createURL(request, "delete-account", "?code=" + verification.getVerificationCode());
        Email email = new Email();
        email.setBody("<p>Hello " + verification.getUsername() + ",</p><p> A request has been made to get a verification code to delete your OpenAIRE account. To delete your account, you will need to submit your username and this verification code in order to verify that the request was legitimate.</p><p>The verification code is " + verification.getVerificationCode() + "</p>Click the URL below and proceed with deleting your account.<p><a href=" + url + ">" + url + "</a></p><p>The verification code is valid for 24 hours.</p><p>Thank you,</p><p>OpenAIRE technical team</p>");
        email.setSubject("Request to delete your OpenAIRE account");
        email.setRecipient(userEmail);
        try {
            this.utilsService.send(email);
        }
        catch (HttpException e) {
            model.addAttribute("server_error", (Object)"Email sent failed");
        }
    }

    public void sendUsernameReminder(Model model, UserVerification verification, String userEmail) {
        Email email = new Email();
        email.setBody("<p>Hello,</p><p> A username reminder has been requested for your OpenAIRE account.</p><p> Your username is <b>" + verification.getUsername() + "</b>.</p><p> Thank you, </p><p> OpenAIRE technical team</p>");
        email.setSubject("Your OpenAIRE username");
        email.setRecipient(userEmail);
        try {
            this.utilsService.send(email);
        }
        catch (HttpException e) {
            model.addAttribute("server_error", (Object)"Email sent failed");
        }
    }

    public void sendForgotPasswordVerification(HttpServletRequest request, Model model, UserVerification verification, String userEmail) {
        String url = this.createURL(request, "verify", "?code=" + verification.getVerificationCode());
        Email email = new Email();
        email.setBody("<p>Hello,</p><p> A request has been made to reset your OpenAIRE account password. To reset your password, you will need to submit this verification code in order to verify that the request was legitimate.</p><p> The verification code is " + verification.getVerificationCode() + "</p>Click the URL below and proceed with verification.<p><a href=" + url + ">" + url + "</a></p><p>The verification code is valid for 24 hours.</p><p>Thank you,</p><p>OpenAIRE technical team</p>");
        email.setSubject("Your OpenAIRE password reset request");
        email.setRecipient(userEmail);
        try {
            this.utilsService.send(email);
        }
        catch (HttpException e) {
            model.addAttribute("server_error", (Object)"Email sent failed");
        }
    }
}

