/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.services;

import eu.dnetlib.uoausermanagment.services.UtilsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"html"})
public class ValidationService {
    public static String VALID_PASSWORD = "^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=\\S+$).{6,}$";
    public static String SPACE = "/[\\s]+/g";
    public static String LOWER_CASE_LETTERS = "/[a-z]/g";
    public static String UPPER_CASE_LETTERS = "/[A-Z]/g";
    public static String NUMBERS = "/[0-9]/g";
    public static String VALID_EMAIL = "^(?=.{1,64}@)[A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)*@[^-][A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";
    public static String VALID_USERNAME = "^[a-zA-Z0-9][a-zA-Z0-9._\\-]{4,150}";
    public static String STARTS_WITH = "^[a-zA-Z0-9].*";
    public static String ALLOWED_CHARS = "^[a-zA-Z0-9._\\-]";
    private final UtilsService service;

    @Autowired
    public ValidationService(UtilsService service) {
        this.service = service;
    }

    public String validateRequired(String input, String error) {
        if (input == null || input.isEmpty()) {
            return error;
        }
        return null;
    }

    public String validateEmail(String email) {
        return this.validateEmail(email, null, false);
    }

    public String validateEmail(String email, String emailConfirmation) {
        return this.validateEmail(email, emailConfirmation, true);
    }

    private String validateEmail(String email, String emailConfirmation, boolean withConfirmation) {
        if (email.isEmpty()) {
            return "Please enter your email.";
        }
        if (email.matches(VALID_EMAIL)) {
            return withConfirmation && !email.equalsIgnoreCase(emailConfirmation) ? "The emails don't match." : null;
        }
        return "Please enter a valid email.";
    }

    public String validateUsername(String username) {
        if (username.matches(VALID_USERNAME)) {
            return null;
        }
        if (this.containsLessCharsThan(5, username)) {
            return "Minimum username length 5 characters.";
        }
        if (this.containsMoreCharsThan(150, username)) {
            return "Maximum username length 150 characters.";
        }
        if (this.containsOnlyAllowedChars(username)) {
            return "You can use letters, numbers, underscores, hyphens and periods.";
        }
        if (this.startsWithLetterOrDigit(username)) {
            return "The username must start with letter or digit.";
        }
        return "Please enter your username";
    }

    public String validatePassword(String password) {
        return this.validatePassword(password, null, false);
    }

    public String validatePassword(String password, String passwordConfirmation) {
        return this.validatePassword(password, passwordConfirmation, true);
    }

    private String validatePassword(String password, String passwordConfirmation, boolean withConfirmation) {
        if (password.matches(VALID_PASSWORD)) {
            return withConfirmation && !password.equals(passwordConfirmation) ? "The passwords don't match." : null;
        }
        if (password.matches(SPACE)) {
            return "No white space allowed.";
        }
        if (!password.matches(LOWER_CASE_LETTERS)) {
            return "Please add a lowercase letter.";
        }
        if (password.matches(UPPER_CASE_LETTERS)) {
            return "Please add a uppercase letter.";
        }
        if (password.matches(NUMBERS)) {
            return "Please add a number.";
        }
        if (this.containsLessCharsThan(6, password)) {
            return "Minimum username length 6 characters.";
        }
        return "Please enter your password";
    }

    public String validateRecaptcha(String recaptchaResponse) {
        return !this.service.processResponse(recaptchaResponse) ? "You missed the reCAPTCHA validation" : null;
    }

    private boolean startsWithLetterOrDigit(String username) {
        return username.matches(STARTS_WITH);
    }

    private boolean containsOnlyAllowedChars(String username) {
        return username.matches(ALLOWED_CHARS);
    }

    private boolean containsLessCharsThan(int count, String input) {
        return input.length() < count;
    }

    private boolean containsMoreCharsThan(int count, String input) {
        return input.length() > count;
    }
}

