function setFields(fields) {
    loading(false);
    fields.forEach(field => {
        if (field === 'username') {
            getTextField(field).onkeyup = function () {
                validateUsername();
            };
        } else if (field === 'password') {
            getTextField(field).onkeyup = function () {
                validatePassword();
            };
        } else if (field === 'password_conf') {
            getTextField(field).onkeyup = function () {
                validatePassword();
            };
        } else if (field === 'email') {
            getTextField(field).onkeyup = function () {
                validateEmail();
            };
        } else if (field === 'email_conf') {
            getTextField(field).onkeyup = function () {
                validateEmail();
            };
        } else if (field === 'verification_code') {
            getTextField(field).onkeyup = function () {
                validateRequired(field, 'Please enter the verification code.');
            };
        } else if (field === 'first_name') {
            getTextField(field).onkeyup = function () {
                validateRequired(field, 'Please enter your first name.');
            };
        } else if (field === 'last_name') {
            getTextField(field).onkeyup = function () {
                validateRequired(field, 'Please enter your last name.');
            };
        }
    });
}

function loading(load) {
    let loading = $('#loading');
    let main = $('#main');
    if(load) {
        loading.show();
        main.hide();
    } else {
        loading.hide();
        main.show();
    }
}

function validateForm(event) {
    loading(true);
    let hasError = !validateRequired('first_name', 'Please enter your first name.');
    let validate = validateRequired('last_name', 'Please enter your last name.')
    if (!hasError) {
        hasError = !validate;
    }
    // Check if username is filled
    validate = validateUsername();
    if (!hasError) {
        hasError = !validate;
    }
    // Check if verification code is filled
    validate = validateRequired('verification_code', 'Please enter the verification code.');
    if (!hasError) {
        hasError = !validate;
    }
    // Check if email is filled and valid
    validate = validateEmail();
    if (!hasError) {
        hasError = !validate;
    }
    //Check if password is filled and valid
    validate = validatePassword();
    if (!hasError) {
        hasError = !validate;
    }
    // CheckRecaptcha
    validate = validateRecaptcha();
    if (!hasError) {
        hasError = !validate;
    }
    if (hasError) {
        loading(false);
        event.preventDefault();
    }
    return !hasError;
}

function validateRequired(field, error) {
    let field_error = $("#" + field + "_error");
    let input = getTextField($("#" + field));
    if (input.val() !== undefined && field_error) {
        field_error.hide();
        let wrapper = getWrapper("#" + field);
        if ($.trim(input.val()).length === 0) {
            field_error.text(function () {
                return error;
            });
            field_error.show();
            wrapper.addClass('danger');
            return false;
        } else {
            field_error.hide();
            wrapper.removeClass('danger');
            return true;
        }
    }
    return true;
}

function validateUsername() {
    let username_error = $("#username_error");
    let username = getTextField("#username")?.val();
    if (username !== undefined && username_error) {
        username_error.hide();
        if (username.length < 5) {
            username_error.text(function () {
                return 'Minimum username length 5 characters.';
            });
            username_error.show();
            return false;
        } else {
            username_error.hide();
            if (username.length >= 150) {
                username_error.text(function () {
                    return 'Maximum username length 150 characters.';
                });
                username_error.show();
                return false;
            } else {
                username_error.hide();
                let allowedChars = /^[a-zA-Z0-9._-]*$/;
                if (!username.match(allowedChars)) {
                    username_error.text(function () {
                        return 'You can use letters, numbers, underscores, hyphens and periods.';
                    });
                    username_error.show();
                    return false;
                } else {
                    username_error.hide();
                    let startsWith = /^[a-zA-Z0-9].*/;
                    if (!username.match(startsWith)) {
                        username_error.text(function () {
                            return 'Username must start with a letter or digit.';
                        });
                        username_error.show();
                        return false;
                    } else {
                        username_error.hide();
                    }
                }
            }
        }
    }
    return true;
}

function validateEmail() {
    const regex = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    let email = getTextField($("#email"))?.val();
    let emailConf = getTextField($("#email_conf"))?.val();
    let email_error = $("#email_error");
    if (email !== undefined) {
        let wrapper = getWrapper("#email");
        if (!validateRequired('email', 'Please enter your email.')) {
            return false;
        } else {
            email_error.hide();
            if (regex.test(email)) {
                email_error.hide();
                if (emailConf != null) {
                    let confWrapper = getWrapper('#email_conf')
                    if (!confirm(email, emailConf)) {
                        wrapper.addClass('danger');
                        confWrapper.addClass('danger');
                        email_error.text(function () {
                            return 'The emails don\'t match.';
                        });
                        email_error.show();
                        return false;
                    } else {
                        email_error.hide();
                        wrapper.removeClass('danger');
                        confWrapper.removeClass('danger');
                    }
                }
                wrapper.removeClass('danger');
                return true;
            } else {
                wrapper.addClass('danger');
                email_error.text(function () {
                    return 'Please enter a valid email.';
                });
                email_error.show();
                return false;
            }
        }
    }
    return true;
}

function validatePassword() {
    let password = getTextField($("#password"))?.val();
    let passwordConf = getTextField($("#password_conf"))?.val();
    let wrapper = getWrapper('#password');
    wrapper.removeClass('danger');
    let password_error = $("#password_error");
    password_error.hide();
    if (password !== undefined) {
        if (!validateRequired('password', 'Please enter your password')) {
            return false;
        } else {
            let space = /[\s]+/g;
            password_error.hide();
            if (password.match(space)) {
                wrapper.addClass('danger');
                password_error.text(function () {
                    return 'No white space allowed.';
                });
                password_error.show();
                return false;
            } else {
                password_error.hide();
                let lowerCaseLetters = /[a-z]/g;
                if (!password.match(lowerCaseLetters)) {
                    wrapper.addClass('danger');
                    password_error.text(function () {
                        return 'Please add a lowercase letter.';
                    });
                    password_error.show();
                    return false;
                } else {
                    password_error.hide();
                    let upperCaseLetters = /[A-Z]/g;
                    if (!password.match(upperCaseLetters)) {
                        wrapper.addClass('danger');
                        password_error.text(function () {
                            return 'Please add a uppercase letter.';
                        });
                        password_error.show();
                        return false;
                    } else {
                        password_error.hide();
                        let numbers = /[0-9]/g;
                        if (!password.match(numbers)) {
                            wrapper.addClass('danger');
                            password_error.text(function () {
                                return 'Please add a number.';
                            });
                            password_error.show();
                            return false;
                        } else {
                            password_error.hide();
                            if (password.length >= 6) {
                                password_error.hide();
                                wrapper.removeClass('danger');
                            } else {
                                wrapper.addClass('danger');
                                password_error.text(function () {
                                    return 'Must contains at least 6 characters.';
                                });
                                password_error.show();
                                return false;
                            }
                        }
                    }
                }
            }

            if (passwordConf !== undefined) {
                let confWrapper = getWrapper('#password_conf')
                if (!confirm(password, passwordConf)) {
                    wrapper.addClass('danger');
                    password_error.text(function () {
                        return 'The passwords don\'t match.';
                    });
                    password_error.show();
                    return false;
                } else {
                    password_error.hide();
                    wrapper.removeClass('danger');
                    confWrapper.removeClass('danger');
                }
            }
            return true;
        }
    }
    return true;
}

function validateRecaptcha() {
    try {
        let recaptcha = grecaptcha.getResponse();
        let recaptcha_error = $("#recaptcha_error");
        if (recaptcha != null && recaptcha.length > 0) {
            recaptcha_error.hide();
            return true;
        } else {
            recaptcha_error.text(function () {
                return 'You missed the reCAPTCHA validation!';
            });
            recaptcha_error.show();
            return false;
        }
    } catch (e) {
        return true;
    }
}

function confirm(first, second) {
    return first === second;
}
