/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.entities;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.UUID;

@Entity
public class UserVerification {
    private static final long EXPIRE_AFTER = 86400000L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String username;
    private String verificationCode;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;

    public UserVerification() {
    }

    public UserVerification(String username) {
        this.username = username;
    }

    public void updateVerificationCode() {
        this.verificationCode = UUID.randomUUID().toString();
        this.date = new Date();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean expired() {
        return new Date().getTime() - this.date.getTime() > 86400000L;
    }
}

