/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.services;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.HttpException;
import eu.dnetlib.uoausermanagment.dto.StringResult;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class HttpService {
    private static final Logger logger = LogManager.getLogger(HttpService.class);
    private final RestTemplate restTemplate;

    @Autowired
    public HttpService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public <S> StringResult post(HttpServletRequest request, String path, S body, Map<String, String> params) {
        return (StringResult)this.post(request, path, body, params, StringResult.class);
    }

    public <T, S> T post(HttpServletRequest request, String path, S body, Map<String, String> params, Class<T> responseType) {
        String url = path + (params != null ? this.createParams(params) : "");
        HttpHeaders headers = this.createHeaders(request);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)(body != null ? body.toString() : ""), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, responseType, new Object[0]);
            if (responseEntity.getBody() != null) {
                return (T)responseEntity.getBody();
            }
            return null;
        }
        catch (HttpClientErrorException e) {
            logger.error("{}: {}", (Object)url, (Object)e.getMessage());
            throw new HttpException(e.getMessage(), HttpStatus.resolve((int)e.getStatusCode().value()));
        }
    }

    public <T, S> T put(HttpServletRequest request, String path, S body, Class<T> responseType) {
        HttpHeaders headers = this.createHeaders(request);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)(body != null ? body.toString() : ""), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(path, HttpMethod.PUT, httpEntity, responseType, new Object[0]);
            if (responseEntity.getBody() != null) {
                return (T)responseEntity.getBody();
            }
            return null;
        }
        catch (HttpClientErrorException e) {
            logger.error("{}: {}", (Object)path, (Object)e.getMessage());
            throw new HttpException(e.getMessage(), HttpStatus.resolve((int)e.getStatusCode().value()));
        }
    }

    public <T> T get(HttpServletRequest request, String path, Map<String, String> params, Class<T> responseType) {
        String url = path + (params != null ? this.createParams(params) : "");
        try {
            return (T)this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.createHeaders(request)), responseType, new Object[0]).getBody();
        }
        catch (HttpClientErrorException e) {
            logger.error("{}: {}", (Object)url, (Object)e.getMessage());
            throw new HttpException(e.getMessage(), HttpStatus.resolve((int)e.getStatusCode().value()));
        }
    }

    public StringResult delete(HttpServletRequest request, String path, Map<String, String> params) {
        return (StringResult)this.delete(request, path, params, StringResult.class);
    }

    public <T> T delete(HttpServletRequest request, String path, Map<String, String> params, Class<T> responseType) {
        String url = path + (params != null ? this.createParams(params) : "");
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, new HttpEntity((MultiValueMap)this.createHeaders(request)), responseType, new Object[0]);
            if (responseEntity.getBody() != null) {
                return (T)responseEntity.getBody();
            }
            return null;
        }
        catch (HttpClientErrorException e) {
            logger.error("{}: {}", (Object)url, (Object)e.getMessage());
            throw new HttpException(e.getMessage(), HttpStatus.resolve((int)e.getStatusCode().value()));
        }
    }

    private String createParams(Map<String, String> params) {
        StringBuilder ret = new StringBuilder("?");
        int count = 0;
        for (Map.Entry<String, String> param : params.entrySet()) {
            ret.append(param.getKey()).append("=");
            ret.append(param.getValue());
            if (++count == params.entrySet().size()) continue;
            ret.append("&");
        }
        return ret.toString();
    }

    private HttpHeaders createHeaders(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.set("Cookie", request.getHeader("Cookie"));
        return headers;
    }
}

