/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.services;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.HttpException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoausermanagment.dao.RoleVerificationDAO;
import eu.dnetlib.uoausermanagment.dto.EmailDetails;
import eu.dnetlib.uoausermanagment.dto.Invitation;
import eu.dnetlib.uoausermanagment.entities.RoleVerification;
import eu.dnetlib.uoausermanagment.entities.VerificationType;
import eu.dnetlib.uoausermanagment.services.UtilsService;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="Verification")
@Profile(value={"registry"})
public class RoleVerificationService {
    private final RoleVerificationDAO dao;
    private final AuthorizationService authorizationService;
    private final UtilsService utilsService;

    @Autowired
    public RoleVerificationService(RoleVerificationDAO dao, AuthorizationService authorizationService, UtilsService utilsService) {
        this.dao = dao;
        this.authorizationService = authorizationService;
        this.utilsService = utilsService;
    }

    private Invitation invite(EmailDetails details, String type, String id, VerificationType verificationType) {
        Invitation invitation = new Invitation(this.dao.findByVerificationTypeAndTypeAndEntityAndEmail(verificationType, type, id, details.getEmail().getRecipient()).orElseGet(() -> (RoleVerification)this.dao.save((Object)new RoleVerification(this.dao, details.getEmail().getRecipient(), verificationType, type, id))));
        details.getEmail().replaceBody(details.getLink(), invitation);
        this.utilsService.send(details.getEmail());
        return invitation;
    }

    private boolean isMyVerification(String id, VerificationType verificationType) {
        RoleVerification verification = (RoleVerification)this.dao.findByIdAndVerificationType(id, verificationType).orElseThrow(() -> new NotFoundException("Role verification with id: " + id + " has not been found for verification type: " + String.valueOf(verificationType)));
        return this.authorizationService.getEmail().equalsIgnoreCase(verification.getEmail());
    }

    public List<String> getInvited(VerificationType verificationType, String type, String id) {
        return this.dao.findByVerificationTypeAndTypeAndEntity(verificationType, type, id).stream().map(RoleVerification::getEmail).toList();
    }

    private void cancelInvitation(VerificationType verificationType, String type, String id, String email) {
        String[] types = new String[]{type};
        if (this.isCommunity(type)) {
            types = new String[]{"community", "ri"};
        }
        this.cancelInvitation(verificationType, types, id, email);
    }

    private void cancelInvitation(VerificationType verificationType, String[] types, String id, String email) {
        Arrays.stream(types).forEach(type -> this.dao.deleteByVerificationTypeAndTypeAndEntityAndEmail(verificationType, type, id, email));
    }

    public Invitation inviteMember(EmailDetails details, String type, String id) {
        return this.invite(details, type, id, VerificationType.MEMBER);
    }

    public Invitation inviteManager(EmailDetails details, String type, String id) {
        return this.invite(details, type, id, VerificationType.MANAGER);
    }

    public void cancelAllInvitation(String type, String id, String email) {
        this.cancelInvitation(VerificationType.MANAGER, type, id, email);
        this.cancelInvitation(VerificationType.MEMBER, type, id, email);
    }

    public void cancelManagerInvitation(String type, String id, String email) {
        this.cancelInvitation(VerificationType.MANAGER, type, id, email);
    }

    public void cancelMemberInvitation(String type, String id, String email) {
        this.cancelInvitation(VerificationType.MEMBER, type, id, email);
    }

    public List<String> getInvitedManagers(String type, String id) {
        return this.getInvited(VerificationType.MANAGER, type, id);
    }

    public List<String> getInvitedMembers(String type, String id) {
        return this.getInvited(VerificationType.MEMBER, type, id);
    }

    public RoleVerification getRoleVerification(String id) {
        return (RoleVerification)this.dao.findById((Object)id).orElseThrow(() -> new NotFoundException("Role verification with id: " + id + " has not been found"));
    }

    public void verify(String id, String code) {
        this.dao.findByIdAndVerificationCode(id, code).orElseThrow(() -> new HttpException("Role verification with id: " + id + " and code " + code + " has not been found", HttpStatus.BAD_REQUEST));
    }

    public boolean isMyManagerVerification(String id) {
        return this.isMyVerification(id, VerificationType.MANAGER);
    }

    public boolean isMyMemberVerification(String id) {
        return this.isMyVerification(id, VerificationType.MEMBER);
    }

    public boolean isMyVerification(String id) {
        RoleVerification verification = this.getRoleVerification(id);
        return this.authorizationService.getEmail().equalsIgnoreCase(verification.getEmail());
    }

    public void deleteVerification(String id) {
        RoleVerification verification = this.getRoleVerification(id);
        this.dao.delete((Object)verification);
    }

    public String getRoleFromVerification(String id) {
        RoleVerification verification = this.getRoleVerification(id);
        if (verification.getVerificationType().equals((Object)VerificationType.MANAGER)) {
            return this.authorizationService.manager(verification.getType(), verification.getEntity());
        }
        return this.authorizationService.member(verification.getType(), verification.getEntity());
    }

    public boolean isCommunity(String type) {
        return type.equalsIgnoreCase("community") || type.equalsIgnoreCase("ri");
    }
}

