/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.dto.form;

import eu.dnetlib.uoausermanagment.dto.form.Form;
import eu.dnetlib.uoausermanagment.services.LDAPService;
import eu.dnetlib.uoausermanagment.services.ValidationService;
import java.io.Serializable;
import org.springframework.ui.Model;

public class RegisterForm
extends Form
implements Serializable {
    public boolean validate(LDAPService ldapService, ValidationService validationService, Model model, String recaptchaResponse) {
        Object usernameError = validationService.validateUsername(this.username);
        if (usernameError == null && ldapService.usernameExists(this.username)) {
            usernameError = "Username " + this.username + " already exists";
        }
        model.addAttribute("username_error", usernameError);
        String passwordError = validationService.validatePassword(this.password, this.passwordConfirmation);
        model.addAttribute("password_error", (Object)passwordError);
        Object emailError = validationService.validateEmail(this.email, this.emailConfirmation);
        if (emailError == null && ldapService.emailExists(this.email)) {
            emailError = "Email " + this.email + " already exists";
        }
        model.addAttribute("email_error", emailError);
        String firstNameError = validationService.validateRequired(this.firstName, "Please enter your first name");
        model.addAttribute("first_name_error", (Object)firstNameError);
        String lastNameError = validationService.validateRequired(this.lastName, "Please enter your last name");
        model.addAttribute("last_name_error", (Object)lastNameError);
        String recaptchaError = validationService.validateRecaptcha(recaptchaResponse);
        model.addAttribute("recaptcha_error", (Object)recaptchaError);
        return usernameError == null && passwordError == null && emailError == null && firstNameError == null && lastNameError == null && recaptchaError == null;
    }
}

