/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.services;

import eu.dnetlib.uoausermanagment.dao.UserRepository;
import eu.dnetlib.uoausermanagment.dao.ZombieUserRepository;
import eu.dnetlib.uoausermanagment.dto.form.RegisterForm;
import eu.dnetlib.uoausermanagment.entities.AccountStatus;
import eu.dnetlib.uoausermanagment.entities.User;
import eu.dnetlib.uoausermanagment.entities.ZombieUser;
import eu.dnetlib.uoausermanagment.utils.SSHAEncoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
@Profile(value={"html"})
public class LDAPService {
    private final Logger logger = LogManager.getLogger(LDAPService.class);
    private final UserRepository userRepository;
    private final ZombieUserRepository zombieUserRepository;
    private final PasswordEncoder passwordEncoder = new SSHAEncoder();

    @Autowired
    public LDAPService(UserRepository userRepository, ZombieUserRepository zombieUserRepository) {
        this.userRepository = userRepository;
        this.zombieUserRepository = zombieUserRepository;
    }

    public boolean matchesPassword(CharSequence password, String encodedPassword) {
        return this.passwordEncoder.matches(password, encodedPassword);
    }

    public AccountStatus accountStatus(String username) {
        if (this.userRepository.findByUsername(username).isPresent()) {
            return AccountStatus.ACTIVATED;
        }
        if (this.zombieUserRepository.findByUsername(username).isPresent()) {
            return AccountStatus.ZOMBIE;
        }
        return AccountStatus.NOT_FOUND;
    }

    public AccountStatus accountStatusByEmail(String email) {
        if (this.userRepository.findByEmail(email).isPresent()) {
            return AccountStatus.ACTIVATED;
        }
        if (this.zombieUserRepository.findByEmail(email).isPresent()) {
            return AccountStatus.ZOMBIE;
        }
        return AccountStatus.NOT_FOUND;
    }

    public boolean usernameExists(String username) {
        return !this.accountStatus(username).equals((Object)AccountStatus.NOT_FOUND);
    }

    public boolean emailExists(String email) {
        return !this.accountStatusByEmail(email).equals((Object)AccountStatus.NOT_FOUND);
    }

    public User getUser(String username) {
        return this.userRepository.findByUsername(username).orElse(null);
    }

    public User getUserByEmail(String email) {
        return this.userRepository.findByEmail(email).orElse(null);
    }

    public ZombieUser getZombieUser(String username) {
        return this.zombieUserRepository.findByUsername(username).orElse(null);
    }

    public ZombieUser getZombieUserByEmail(String email) {
        return this.zombieUserRepository.findByEmail(email).orElse(null);
    }

    public String moveUser(String username) {
        ZombieUser zombieUser = this.zombieUserRepository.findByUsername(username).orElse(null);
        try {
            if (zombieUser != null) {
                User user = new User(zombieUser);
                this.zombieUserRepository.delete((Object)zombieUser);
                this.userRepository.save((Object)user);
                return null;
            }
            return "User has not been found";
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return "Something wrong happened. Please try again later.";
        }
    }

    public String updateUserPassword(String username, String password) {
        User user = this.userRepository.findByUsername(username).orElse(null);
        try {
            if (user != null) {
                user.setUserPassword(this.passwordEncoder.encode((CharSequence)password));
                user.setNew(false);
                this.userRepository.save((Object)user);
                return null;
            }
            return "User has not been found";
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return "Something wrong happened. Please try again later.";
        }
    }

    public ZombieUser createZombieUser(RegisterForm form, Model model) {
        try {
            ZombieUser user = new ZombieUser(form);
            user.setUserPassword(this.passwordEncoder.encode((CharSequence)form.getPassword()));
            return (ZombieUser)this.zombieUserRepository.save((Object)user);
        }
        catch (Exception e) {
            model.addAttribute("server_error", (Object)"LDAP error in creating user");
            return null;
        }
    }

    public String deleteUser(String username) {
        if (this.accountStatus(username).equals((Object)AccountStatus.ACTIVATED)) {
            this.userRepository.delete((Object)this.getUser(username));
            return null;
        }
        if (this.accountStatus(username).equals((Object)AccountStatus.ZOMBIE)) {
            this.zombieUserRepository.delete((Object)this.getZombieUser(username));
            return null;
        }
        return "User has not been found";
    }
}

