/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.controllers;

import eu.dnetlib.uoausermanagment.configuration.Properties;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
@Profile(value={"html"})
public class PageController {
    private final String loginUrl;

    @Autowired
    public PageController(Properties properties) {
        this.loginUrl = properties.getLoginUrl();
    }

    @GetMapping(value={"/bad-request"})
    public String error(HttpServletRequest request) {
        if (request.getSession().getAttribute("error") != null) {
            request.getSession().removeAttribute("error");
            return "general-error";
        }
        return "redirect:/error";
    }

    @GetMapping(value={"/expired"})
    public String expired(HttpServletRequest request) {
        if (Objects.equals(request.getSession().getAttribute("expired"), true)) {
            request.getSession().removeAttribute("expired");
            return "expired";
        }
        return "redirect:/error";
    }

    @GetMapping(value={"/register-success"})
    public String registerSuccess(HttpServletRequest request, Model model) {
        if (Objects.equals(request.getSession().getAttribute("register-success"), true)) {
            request.getSession().removeAttribute("register-success");
            model.addAttribute("loginUrl", (Object)this.loginUrl);
            return "register-success";
        }
        return "redirect:/error";
    }

    @GetMapping(value={"/email-success"})
    public String emailSuccess(HttpServletRequest request) {
        if (Objects.equals(request.getSession().getAttribute("email-success"), true)) {
            request.getSession().removeAttribute("email-success");
            return "email-success";
        }
        return "redirect:/error";
    }

    @GetMapping(value={"/password-success"})
    public String passwordSuccess(HttpServletRequest request) {
        if (Objects.equals(request.getSession().getAttribute("password-success"), true)) {
            request.getSession().removeAttribute("password-success");
            return "password-success";
        }
        return "redirect:/error";
    }

    @GetMapping(value={"/delete-success"})
    public String deleteSuccess(HttpServletRequest request) {
        if (Objects.equals(request.getSession().getAttribute("delete-success"), true)) {
            request.getSession().removeAttribute("delete-success");
            return "delete-success";
        }
        return "redirect:/error";
    }

    @GetMapping(value={"/email-confirmation"})
    public String confirmEmail() {
        return "email-confirmation";
    }
}

