/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.result_models;

import eu.dnetlib.validator2.result_models.Result;
import eu.dnetlib.validator2.result_models.Status;
import eu.dnetlib.validator2.result_models.ValidationProblem;
import java.util.Collections;
import java.util.List;

public class StandardResult
implements Result {
    private static final List<ValidationProblem> EMPTY = Collections.emptyList();
    private List<ValidationProblem> warnings;
    private List<ValidationProblem> errors;
    private String internalError;
    private Status status;
    private int score;

    public StandardResult() {
    }

    public StandardResult(int score, Status status, List<ValidationProblem> warnings, List<ValidationProblem> errors, String internalError) {
        this.status = status;
        this.score = score;
        this.warnings = warnings;
        this.errors = errors;
        this.internalError = internalError;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public void setScore(int score) {
        this.score = score;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public List<ValidationProblem> getWarnings() {
        return this.warnings;
    }

    @Override
    public void setWarnings(List<ValidationProblem> warnings) {
        this.warnings = warnings;
    }

    @Override
    public List<ValidationProblem> getErrors() {
        return this.errors;
    }

    @Override
    public void setErrors(List<ValidationProblem> errors) {
        this.errors = errors;
    }

    @Override
    public String getInternalError() {
        return this.internalError;
    }

    @Override
    public void setInternalError(String internalError) {
        this.internalError = internalError;
    }

    public static StandardResult forError(String message) {
        return new StandardResult(-1, Status.ERROR, EMPTY, EMPTY, message);
    }

    public static StandardResult forSuccess(int score, List<ValidationProblem> warnings) {
        return new StandardResult(score, Status.SUCCESS, StandardResult.sanitize(warnings), EMPTY, null);
    }

    public static StandardResult forFailure(List<ValidationProblem> warnings, List<ValidationProblem> errors) {
        return new StandardResult(0, Status.FAILURE, StandardResult.sanitize(warnings), StandardResult.sanitize(errors), null);
    }

    private static List<ValidationProblem> sanitize(List<ValidationProblem> list) {
        if (list == null || list.size() == 0) {
            return EMPTY;
        }
        return Collections.unmodifiableList(list);
    }

    public String toString() {
        if (this.status == Status.SUCCESS || this.status == Status.FAILURE) {
            return (Object)((Object)this.status) + " (" + this.warnings.size() + " warnings) - score " + this.score;
        }
        return (Object)((Object)this.status) + " (" + this.warnings.size() + " warnings) - " + this.internalError;
    }
}

