/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.Status;
import eu.dnetlib.validator2.engine.builtins.StandardXMLContext;
import eu.dnetlib.validator2.engine.builtins.XMLCardinalityRule;
import eu.dnetlib.validator2.engine.builtins.XMLRule;
import eu.dnetlib.validator2.validation.StandardValidationResult;
import eu.dnetlib.validator2.validation.XMLApplicationProfile;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import java.io.Serializable;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractOpenAireProfile
implements XMLApplicationProfile,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOpenAireProfile.class);
    private final String name;

    public AbstractOpenAireProfile(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public XMLApplicationProfile.ValidationResult validate(String id, Document document) {
        int maxScore = this.maxScore();
        double score = 0.0;
        HashMap<String, Guideline.Result> results = new HashMap<String, Guideline.Result>();
        for (Guideline<Document> guideline : this.guidelines()) {
            String guidelineElementName = guideline.getName();
            if (logger.isTraceEnabled()) {
                logger.trace("Evaluating guideline-element: " + guidelineElementName);
            }
            Guideline.Result result = guideline.validate(document);
            results.put(guidelineElementName, result);
            logger.debug("Score after validating \"" + guidelineElementName + "\" = " + (score += (double)(result.getStatus() == Status.SUCCESS ? result.getScore() : 0)));
        }
        double percentScore = score / (double)maxScore * 100.0;
        return new StandardValidationResult(id, percentScore, results);
    }

    static Rule<Document> elementIsPresent(String elementName) {
        return XMLCardinalityRule.builder().setId("ApplicabilityRule").setXPathExpression("//*[name()='" + elementName + "']").setIsInclusive(true).setRange(1L, Long.MAX_VALUE).build();
    }

    static Rule<Document> elementIsPresentAndHasAttributeWithValue(String elementName, String attrName, String attrValue) {
        StandardXMLContext context = new StandardXMLContext();
        context.getIdProperty().setValue("ApplicabilityRule");
        context.getNodeListActionProperty().setValue("custom");
        context.getXPathExpressionProperty().setValue("//*[name()='" + elementName + "']");
        return new XMLRule<StandardXMLContext>(context, nodes -> {
            int len = nodes.getLength();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                Node elem = nodes.item(i);
                String value = Helper.getAttributeValue(elem, attrName);
                if (attrValue.equals(value)) continue;
                return false;
            }
            return true;
        });
    }
}

