/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.StandardResult;
import eu.dnetlib.validator2.validation.guideline.openaire.F2_01M_LIT;
import eu.dnetlib.validator2.validation.guideline.openaire.F2_01M_SPEC;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class F2_01M_SPEC_LIT
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(F2_01M_SPEC.class);

    public F2_01M_SPEC_LIT() {
        super("data are described with rich metadata", "F2", "description", "https://w3id.org/fair/principles/latest/F2", "F", 1, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        F2_01M_LIT profile = new F2_01M_LIT();
        try {
            StandardValidationResult res_F = profile.validate(id, t);
            Map<String, StandardResult> results = res_F.getResults();
            int MaxScoreF2_01M_LIT_SPEC = (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            ArrayList<String> warnings2 = new ArrayList<String>();
            ArrayList<String> errors2 = new ArrayList<String>();
            int score = 0;
            for (Map.Entry<String, StandardResult> entry : results.entrySet()) {
                String key = entry.getKey();
                String warningsStr = results.get(key).getWarnings().toString();
                String errorsStr = results.get(key).getErrors().toString();
                if (warningsStr.length() > 2) {
                    warnings2.add(warningsStr);
                }
                if (errorsStr.length() > 2) {
                    errors2.add(errorsStr);
                }
                if (entry.getValue().toString().contains("SUCCESS")) {
                    score += 2;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace(String.valueOf(results.get(key).getWarnings().getClass()));
                logger.trace(String.valueOf(warnings2.getClass()));
            }
            StandardResult ress = F2_01M_SPEC_LIT.getResult(warnings2, errors2, MaxScoreF2_01M_LIT_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(List<String> warnings2, List<String> errors2, int score2) {
        return ResultUtils.getNewResult(warnings2, errors2, score2);
    }
}

