/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleEvaluationException;
import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.builtins.ForwardingRule;

public class ConditionalRule<T>
extends ForwardingRule<T> {
    protected final Rule<T> conditionRule;
    protected final WhenConditionFails whenConditionFails;

    public ConditionalRule(Rule<T> actualRule, Rule<T> conditionRule, WhenConditionFails whenConditionFails) {
        super(actualRule);
        this.conditionRule = conditionRule;
        this.whenConditionFails = whenConditionFails;
    }

    @Override
    public RuleValidationResult test(T t) throws RuleEvaluationException {
        RuleValidationResult result = this.conditionRule.test(t);
        if (result.isSuccess()) {
            return super.test(t);
        }
        if (this.whenConditionFails == WhenConditionFails.RULE_SUCCEEDS) {
            return RuleValidationResult.success();
        }
        return RuleValidationResult.failure("the conditional rule failed: " + result.getMessage(), "Ensure the condition for this rule is met. " + result.getSuggestion());
    }

    public static enum WhenConditionFails {
        RULE_FAILS,
        RULE_SUCCEEDS;

    }
}

