package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.*;
import eu.dnetlib.validator2.engine.contexts.XMLContextWithNotConfusedFields;
import eu.dnetlib.validator2.engine.contexts.XPathExpressionProperty;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class XMLNotConfusedFieldsRule implements Rule<Document> {

    private final XMLContextWithNotConfusedFields context;

    protected XMLNotConfusedFieldsRule(XMLContextWithNotConfusedFields context) {
        this.context = context;
    }

    @Override
    public RuleContext getContext() {
        return context;
    }

    @Override //TODO Is a bit different from original evaluation. Needs revisit probably.
    public RuleValidationResult test(Document doc) throws RuleEvaluationException {
        XPathExpressionProperty xpathExprProp = context.getXPathExpressionProperty();
        Set<String> allNodeValues = new HashSet<>();
        try {
            for (String xpath : context.getFieldsProperty().getXpaths()) {
                xpathExprProp.setValue(xpath);
                NodeList nodesReturned = xpathExprProp.evaluate(doc);

                TestResultPredicate<String> uniqueValuesPredicate = (String v) -> {
                    String val = v.trim().toLowerCase();
                    if ( allNodeValues.add(val) )
                        return RuleValidationResult.success();
                    else
                        return RuleValidationResult.failure("duplicate value '" + val + "' found across fields", "Ensure that the values of the specified fields are unique.");
                };

                RuleValidationResult result = context.getNodeListActionProperty().test(nodesReturned, uniqueValuesPredicate);
                if ( !result.isSuccess() )
                    return result;
            }
            return RuleValidationResult.success();
        } catch (Throwable t) {
            throw new RuleEvaluationException(t.getMessage(), t);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "XMLNotConfusedFieldsRule{" +
                "context=" + context +
                '}';
    }

    public static class Builder extends AbstractRuleBuilder<XMLNotConfusedFieldsRule, XMLContextWithNotConfusedFields> {

        Builder() {
            super(new StandardXMLContextWithNotConfusedFields());
            initialize();
        }

        private void initialize() {
            context.getXPathExpressionProperty().setValue("notNull");
            context.getNodeListActionProperty().setValue("all");
        }

        public Builder setId(String id) {
            context.getIdProperty().setValue(id);
            return this;
        }

        public Builder setFields(String fields) {
            context.getFieldsProperty().setValue(fields);
            return this;
        }

        @Override
        public XMLNotConfusedFieldsRule build() {
            ensureContextIsValid();
            return new XMLNotConfusedFieldsRule(context);
        }

        @Override
        public XMLNotConfusedFieldsRule buildFrom(Map<String, String> map) {
            context.readFrom(map);
            ensureContextIsValid();
            return new XMLNotConfusedFieldsRule(context);
        }

    }

}
