package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.utils.MediaTypesValuePredicate;
import org.w3c.dom.Document;

import java.util.*;
import java.util.stream.Collectors;

import static eu.dnetlib.validator2.validation.guideline.Cardinality.ONE_TO_N;

public final class F3_01M_LIT extends AbstractOpenAireProfile {

    private static final String[] RESOURCE_IDENTIFIER_TYPES = {
            "ARK", "DOI", "Handle", "IGSN", "arXiv", "PURL", "URL", "URN", "PMID"
    };

    private static final String[] IDENTIFIER_TYPES = {
            "ARK", "arXiv", "bibcode", "DOI", "EAN13", "EISSN", "Handle", "IGSN", "QID", "ISBN", "IVOA",
            "RRID", "RInChi", "ERM", "ISO 27729:2012 ISNI", "EC Number", "TFClass Schema", "InChI", "w3id",
            "ISSN", "ISTC", "LISSN", "ISSNL", "LSID", "PISSN", "PMID", "PURL", "UPC", "URL", "URN", "WOS", "ORCID iD"
    };

    private static final String[] RELATION_TYPES = {
            "IsDescribedBy", "Describes", "HasMetadata", "IsMetadataFor", "Documents", "IsDerivedFrom", "IsSourceOf"
    };

//    private static final String[] RELATION_TYPES = {
//            "IsCitedBy", "Cites", "IsSupplementTo", "IsSupplementedBy", "IsContinuedBy",
//            "Continues", "IsDescribedBy", "Describes", "HasMetadata", "IsMetadataFor", "HasVersion",
//            "IsVersionOf", "IsNewVersionOf", "IsPreviousVersionOf", "IsPartOf", "HasPart", "IsReferencedBy",
//            "References", "IsDocumentedBy", "Documents", "IsCompiledBy", "Compiles", "IsVariantFormOf",
//            "IsOriginalFormOf", "IsIdenticalTo", "IsReviewedBy", "Reviews", "IsDerivedFrom", "IsSourceOf",
//            "IsRequiredBy", "Requires"
//    };

    private static final String[] RELATED_RESOURCE_GENERAL_TYPES = {
            "Audiovisual", "Collection", "DataPaper", "Dataset", "Event", "Image", "InteractiveResource",
            "Model", "PhysicalObject", "Service", "Software", "Sound", "Text", "Workflow", "Other"
    };

    private static final String[] FILE_OBJECT_TYPES = {
            "dataset", "software", "other"
    };

//    private static final ElementSpec F3_01M_LIT_SPEC_1 = Builders.
//            forMandatoryElement("datacite:identifier", ONE).
////            withMandatoryAttribute("identifierType", new PIDCheckValuePredicate()).
//            withMandatoryAttribute("identifierType", RESOURCE_IDENTIFIER_TYPES).
//            build();
//
//    private static final ElementSpec F3_01M_LIT_SPEC_2 = Builders.
//            forMandatoryElement("datacite:alternateIdentifier", ONE_TO_N).
    /// /            withMandatoryAttribute("identifierType", new PIDCheckValuePredicate()).
//        withMandatoryAttribute("alternateIdentifierType", PERSISTENT_IDENTIFIER_TYPES).
//            build();

    private static final ElementSpec F3_01M_LIT_SPEC_1 = Builders.
            forMandatoryElement("oaire:file", ONE_TO_N).
            withRecommendedAttribute("mimeType", new MediaTypesValuePredicate()).
            withRecommendedAttribute("objectType", FILE_OBJECT_TYPES).
            build();

    private static final ElementSpec F3_01M_LIT_SPEC_2 = Builders.
            forMandatoryElement("datacite:relatedIdentifier", ONE_TO_N).
            withMandatoryAttribute("relatedIdentifierType", IDENTIFIER_TYPES).
            withMandatoryAttribute("relationType", RELATION_TYPES).
            //TODO: For following 3 attributes. Need a way to target relationType attribute of current element
            // - Should be used only with relation type (HasMetadata/IsMetadataFor).
                withOptionalAttribute("relatedMetadataScheme").
                withOptionalAttribute("schemeURI").
                withOptionalAttribute("schemeType").
                withOptionalAttribute("resourceTypeGeneral", RELATED_RESOURCE_GENERAL_TYPES).
            build();


    //TODO: weights for guidelines haven't been finalized. They've been given an arbitrary value of 1.
    public static SyntheticGuideline F3_01M_LIT_1 = SyntheticGuideline.of("File", 1, F3_01M_LIT_SPEC_1);
    public static SyntheticGuideline F3_01M_LIT_2 = SyntheticGuideline.of("RelatedIdentifier", 1, F3_01M_LIT_SPEC_2);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(
            Arrays.asList(
                    F3_01M_LIT_1,
                    F3_01M_LIT_2
            )
    );

    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.
            stream().
            collect(Collectors.toMap(Guideline::getName, (guideline) -> guideline));

    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public F3_01M_LIT() {
        super("metadata clearly and explicitly include the identifier of the data it describes");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    /**
     * @param guidelineName
     * @return
     */
    @Override
    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}