package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.*;
import org.w3c.dom.Document;

import java.util.*;
import java.util.stream.Collectors;

import static eu.dnetlib.validator2.validation.guideline.Cardinality.ONE;

public final class I2_01M_LIT_v3 extends AbstractOpenAireProfile {

    private static final String[] repoAccessTerms = {
            "info:eu-repo/semantics/closedAccess",
            "info:eu-repo/semantics/embargoedAccess",
            "info:eu-repo/semantics/restrictedAccess",
            "info:eu-repo/semantics/openAccess"
    };

    private static final String[] publicationTypes = {
            "info:eu-repo/semantics/article",
            "info:eu-repo/semantics/bachelorThesis",
            "info:eu-repo/semantics/masterThesis",
            "info:eu-repo/semantics/doctoralThesis",
            "info:eu-repo/semantics/book",
            "info:eu-repo/semantics/bookPart",
            "info:eu-repo/semantics/review",
            "info:eu-repo/semantics/conferenceObject",
            "info:eu-repo/semantics/lecture",
            "info:eu-repo/semantics/workingPaper",
            "info:eu-repo/semantics/preprint",
            "info:eu-repo/semantics/report",
            "info:eu-repo/semantics/annotation",
            "info:eu-repo/semantics/contributionToPeriodical",
            "info:eu-repo/semantics/patent",
            "info:eu-repo/semantics/other"
    };

    private static final ElementSpec RESOURCE_TYPE_SPEC = Builders.
            forMandatoryElement("dc:type", ONE).
            atPosition(ElementPosition.FIRST).
            allowedValues(publicationTypes).
            build();

    private static final ElementSpec ACCESS_RIGHTS_SPEC = Builders.
            forMandatoryElement("dc:rights", ONE).
            allowedValues(repoAccessTerms).
            build();

    //TODO: weights for guidelines haven't been finalized. They've been given an arbitrary value of 1.
    public static SyntheticGuideline I2_01M_LIT_v3_1 = SyntheticGuideline.of("Resource Type", 1, RESOURCE_TYPE_SPEC);
//    public static SyntheticGuideline I2_01M_LIT_2 = SyntheticGuideline.of("Subject", 1, SUBJECT_SPEC);
    public static SyntheticGuideline I2_01M_LIT_v3_3 = SyntheticGuideline.of("Rights", 1, ACCESS_RIGHTS_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(
            Arrays.asList(
                    I2_01M_LIT_v3_1,
//                    I2_01M_LIT_2,
                    I2_01M_LIT_v3_3
            )
    );

    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.
            stream().
            collect(Collectors.toMap(Guideline::getName, (guideline) -> guideline));

    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public I2_01M_LIT_v3() {
        super("(meta)data use vocabularies that follow FAIR principles");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    /**
     *
     * @param guidelineName
     * @return
     */
    @Override
    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() { return MAX_SCORE; }
}