package eu.dnetlib.validator2.validation.utils;

import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;

public class MediaTypesValuePredicate implements TestResultPredicate<String> {

    @Override
    public RuleValidationResult test(String s) {
        if ( s == null || s.isEmpty() )
            return RuleValidationResult.failure("input string is null or empty", "Provide a valid IANA media type.");
        else if ( MediaTypes.contains(s) )
            return RuleValidationResult.success();
        else
            return RuleValidationResult.failure("value '" + s + "' is not a valid media type", "Use a valid IANA media type (e.g., 'application/pdf', 'text/xml').");
    }
}
