/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.utils.RegexValuePredicate;
import eu.dnetlib.validator2.validation.utils.SupportedRegExs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class F2_01M_LIT
extends AbstractOpenAireProfile {
    private static final String[] TITLE_TYPES = new String[]{"AlternativeTitle", "Subtitle", "TranslatedTitle", "Other"};
    private static final String[] NAME_TYPES = new String[]{"Organizational", "Personal"};
    private static final String[] DATE_TYPES = new String[]{"Accepted", "Available", "Issued"};
    private static final String[] FUNDER_IDENTIFIER_TYPES = new String[]{"ISNI", "GRID", "Crossref Funder"};
    private static final ElementSpec F2_01M_LIT_SPEC_1 = Builders.forElement("datacite:creator", RequirementLevel.RECOMMENDED, Cardinality.ONE_TO_N).withSubElement(Builders.forMandatoryElement("datacite:creatorName", Cardinality.ONE).withRecommendedAttribute("nameType", NAME_TYPES)).withSubElement(Builders.forRecommendedElement("datacite:givenName")).withSubElement(Builders.forRecommendedElement("datacite:familyName")).withSubElement(Builders.forRecommendedRepeatableElement("datacite:nameIdentifier").withMandatoryAttribute("nameIdentifierScheme").withRecommendedAttribute("schemeURI")).withSubElement(Builders.forRecommendedRepeatableElement("datacite:affiliation")).build();
    private static final ElementSpec F2_01M_LIT_SPEC_2 = Builders.forElement("datacite:title", RequirementLevel.RECOMMENDED, Cardinality.ONE_TO_N).withOptionalAttribute("xml:lang", new RegexValuePredicate(SupportedRegExs.COMPILED_BCP47_LANG_TAGS_REG_EX)).withOptionalAttribute("titleType", TITLE_TYPES).build();
    private static final ElementSpec F2_01M_LIT_SPEC_3 = Builders.forElement("dc:publisher", RequirementLevel.RECOMMENDED, Cardinality.ONE_TO_N).build();
    private static final ElementSpec F2_01M_LIT_SPEC_4 = Builders.forElement("datacite:date", RequirementLevel.RECOMMENDED, Cardinality.ONE_TO_N).withMandatoryAttribute("dateType", DATE_TYPES).allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_PUBLICATION_DATE_REG_EX).or(new RegexValuePredicate(SupportedRegExs.COMPILED_YYYY_MM_DD_RANGE_REGEX).or(new RegexValuePredicate(SupportedRegExs.COMPILED_YEAR_YYYY_REG_EX)))).build();
    private static final ElementSpec F2_01M_LIT_SPEC_5 = Builders.forElement("dc:description", RequirementLevel.RECOMMENDED, Cardinality.ONE_TO_N).withOptionalAttribute("xml:lang", new RegexValuePredicate(SupportedRegExs.COMPILED_BCP47_LANG_TAGS_REG_EX)).build();
    private static final ElementSpec F2_01M_LIT_SPEC_6 = Builders.forElement("datacite:subject", RequirementLevel.RECOMMENDED, Cardinality.ONE_TO_N).withOptionalAttribute("subjectScheme").withOptionalAttribute("schemeURI").withOptionalAttribute("valueURI").build();
    private static final ElementSpec F2_01M_LIT_SPEC_7 = Builders.forMandatoryIfApplicableElement("oaire:fundingReference", Cardinality.ONE_TO_N, F2_01M_LIT.elementIsPresent("oaire:fundingReference")).withSubElement(Builders.forMandatoryElement("oaire:funderName", Cardinality.ONE)).withSubElement(Builders.forRecommendedElement("oaire:funderIdentifier").withRecommendedAttribute("funderIdentifierType", FUNDER_IDENTIFIER_TYPES)).withSubElement(Builders.forOptionalElement("oaire:fundingStream")).withSubElement(Builders.forMandatoryIfApplicableElement("oaire:awardNumber", Cardinality.ONE, F2_01M_LIT.elementIsPresent("oaire:awardNumber")).withRecommendedAttribute("awardURI")).withSubElement(Builders.forRecommendedElement("oaire:awardTitle")).build();
    public static SyntheticGuideline F2_01M_LIT_1 = SyntheticGuideline.of("Creator", 2, F2_01M_LIT_SPEC_1);
    public static SyntheticGuideline F2_01M_LIT_2 = SyntheticGuideline.of("Title", 2, F2_01M_LIT_SPEC_2);
    public static SyntheticGuideline F2_01M_LIT_3 = SyntheticGuideline.of("Publisher", 2, F2_01M_LIT_SPEC_3);
    public static SyntheticGuideline F2_01M_LIT_4 = SyntheticGuideline.of("Date", 2, F2_01M_LIT_SPEC_4);
    public static SyntheticGuideline F2_01M_LIT_5 = SyntheticGuideline.of("Summary (Description with descriptionType)", 2, F2_01M_LIT_SPEC_5);
    public static SyntheticGuideline F2_01M_LIT_6 = SyntheticGuideline.of("Keywords (Subjects)", 2, F2_01M_LIT_SPEC_6);
    public static SyntheticGuideline F2_01M_LIT_7 = SyntheticGuideline.of("Funding Reference", 2, F2_01M_LIT_SPEC_7);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(F2_01M_LIT_1, F2_01M_LIT_2, F2_01M_LIT_3, F2_01M_LIT_4, F2_01M_LIT_5, F2_01M_LIT_6, F2_01M_LIT_7));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public F2_01M_LIT() {
        super("Rich metadata is provided to allow discovery");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

