/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.F2_01M_LIT_v3;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class F2_01M_SPEC_LIT_v3
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(F2_01M_SPEC_LIT_v3.class);

    public F2_01M_SPEC_LIT_v3() {
        super("data are described with rich metadata", "F2", "description", "https://w3id.org/fair/principles/latest/F2", "F", 1, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        F2_01M_LIT_v3 profile = new F2_01M_LIT_v3();
        try {
            StandardValidationResult res_F = profile.validate(id, t);
            Map results = res_F.getResults();
            int MaxScoreF2_01M_LIT_SPEC = (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            StandardResult ress = F2_01M_SPEC_LIT_v3.getResult(results.entrySet(), MaxScoreF2_01M_LIT_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(Set<Map.Entry<String, StandardResult>> data, int score) {
        return ResultUtils.getNewResult(data, score);
    }
}

