package eu.dnetlib.validator2.validation;

import eu.dnetlib.validator2.result_models.ValidationResult;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import org.w3c.dom.Document;

import java.util.Collection;
import java.util.List;

/**
 * An application-specific collection of guidelines
 */
public interface XMLApplicationProfile {

    String name();

    Collection<? extends Guideline<Document>> guidelines();

    Guideline<Document> guideline(String guidelineName);

    ValidationResult validate(String id, Document document);

    ValidationResult validate(String id, List<String> feirRuleIds, Document document);

    int maxScore();
}
