package eu.dnetlib.validator2.validation.task;

import eu.dnetlib.validator2.result_models.ValidationProblem;

public final class RuleEvaluationResult {

    private static final byte SUCCESS     = 0;
    private static final byte FAILURE     = 2;
    private static final byte ERROR       = 4;
    private static final byte INTERRUPTED = 8;

    private final byte result;
    private final ValidationProblem problem;

    RuleEvaluationResult(byte result, ValidationProblem problem) {
        this.result = result;
        this.problem = problem;
    }

    public boolean succeeded() { return result == SUCCESS; }

    public boolean failed() { return result == FAILURE; }

    public boolean errored() { return result == ERROR; }

    public boolean interrupted() { return result == INTERRUPTED; }

    public ValidationProblem getProblem() {
        return problem;
    }

    static RuleEvaluationResult forSuccess() {
        return new RuleEvaluationResult(SUCCESS, null);
    }

    static RuleEvaluationResult forFailure(String message, String suggestion) {
        return new RuleEvaluationResult(FAILURE, new ValidationProblem(message, suggestion));
    }

    static RuleEvaluationResult forError(String errorMessage) {
        return new RuleEvaluationResult(ERROR, new ValidationProblem(errorMessage, null));
    }

    static RuleEvaluationResult forInterrupted() {
        return new RuleEvaluationResult(INTERRUPTED, null);
    }
}
