package eu.dnetlib.validator2.validation.utils;

import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.Status;
import eu.dnetlib.validator2.result_models.ValidationProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultUtils {

	private static final Logger logger = LoggerFactory.getLogger(ResultUtils.class);


	public static StandardResult getNewResult(Set<Map.Entry<String, StandardResult>> data, int score2) {

		boolean shouldAssignScoreInLoop = (score2 == -1);
		if ( shouldAssignScoreInLoop )
			score2 = 0;

		ArrayList<ValidationProblem> warnings2 = new ArrayList<>();
		ArrayList<ValidationProblem> errors2 = new ArrayList<>();
		for (Map.Entry<String, StandardResult> entry : data) {
			String key = entry.getKey();
			StandardResult standardResult = entry.getValue();
            List<ValidationProblem> warnings = standardResult.getWarnings();
            List<ValidationProblem> errors = standardResult.getErrors();
			if ( !warnings.isEmpty() ) {
				warnings2.addAll(warnings);
			}
            if ( !errors.isEmpty() ) {
                errors2.addAll(errors);
			}
			if ( shouldAssignScoreInLoop && standardResult.toString().contains("SUCCESS") ) {
				score2 += 3;
			}
			if ( logger.isTraceEnabled() ) {
				logger.trace(String.valueOf(standardResult.getWarnings().getClass()));
				logger.trace(String.valueOf(warnings2.getClass()));
			}
		}

		final StandardResult result = new StandardResult() {

			private int score;
			private Status status;
			private List<ValidationProblem> warnings;
			private List<ValidationProblem> errors;
			private String internalError;


			@Override
			public int getScore() {
				return this.score;
			}

			@Override
			public void setScore(int score) {
				this.score = score;
			}

			@Override
			public Status getStatus() {
				return this.status;
			}

			@Override
			public void setStatus(Status status) {
				this.status = status;
			}

			@Override
			public List<ValidationProblem> getWarnings() {
				return this.warnings;
			}

			@Override
			public void setWarnings(List<ValidationProblem> warnings) {
				this.warnings = warnings;
			}

			@Override
			public List<ValidationProblem> getErrors() {
				return this.errors;
			}

			@Override
			public void setErrors(List<ValidationProblem> errors) {
				this.errors = errors;
			}

			@Override
			public String getInternalError() {
				return this.internalError;
			}

			@Override
			public void setInternalError(String internalError) {
				this.internalError = internalError;
			}
		};

		result.setScore(score2);
		result.setStatus(Status.valueOf((score2 > 0) ? "SUCCESS" : "FAILURE"));
		result.setWarnings(warnings2);
		result.setErrors(errors2);

		return result;
	}

}
