/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import eu.dnetlib.validator2.engine.RuleEvaluationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathExpressionHelper {
    private static final Logger logger = LoggerFactory.getLogger(XPathExpressionHelper.class);
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final ConcurrentHashMap<String, XPathExpression> COMPILED_EXPRESSIONS = new ConcurrentHashMap();
    private static final int MAX_CACHE_ENTRIES = 100;
    private static final LoadingCache<Document, ConcurrentMap<XPathExpression, NodeList>> EVALUATED_EXPRESSIONS = CacheBuilder.newBuilder().maximumSize(100L).weakKeys().build((CacheLoader)new CacheLoader<Document, ConcurrentMap<XPathExpression, NodeList>>(){

        public ConcurrentMap<XPathExpression, NodeList> load(Document key) {
            return new ConcurrentHashMap<XPathExpression, NodeList>();
        }
    });

    public static XPathExpression compile(String xpath) {
        return COMPILED_EXPRESSIONS.computeIfAbsent(xpath, s -> {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Compiling {}", s);
                }
                XPathExpression expr = XPATH.compile((String)s);
                return expr;
            }
            catch (XPathExpressionException e) {
                logger.error("Compilation failure", (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    public static NodeList nodeList(String xpath, Document doc) {
        logger.debug("Evaluating nodeList {}", (Object)xpath);
        return XPathExpressionHelper.nodeList(XPathExpressionHelper.compile(xpath), doc);
    }

    public static NodeList nodeList(XPathExpression expr, Document doc) {
        try {
            return ((ConcurrentMap)EVALUATED_EXPRESSIONS.get((Object)doc)).computeIfAbsent(expr, xpath -> {
                try {
                    NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                    return nodes;
                }
                catch (XPathExpressionException ex) {
                    throw new RuleEvaluationException(ex.getMessage(), ex);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuleEvaluationException(e.getMessage(), e);
        }
    }

    public static String attr(String xpath, Node node) {
        logger.debug("Evaluating attr {}", (Object)xpath);
        return XPathExpressionHelper.attr(XPathExpressionHelper.compile(xpath), node);
    }

    public static String attr(XPathExpression expr, Node node) {
        try {
            String value = expr.evaluate(node);
            return value;
        }
        catch (XPathExpressionException ex) {
            throw new RuleEvaluationException(ex.getMessage(), ex);
        }
    }

    public static Node node(String xpath, Node node) {
        logger.debug("Evaluating node {}", (Object)xpath);
        return XPathExpressionHelper.node(XPathExpressionHelper.compile(xpath), node);
    }

    public static Node node(XPathExpression expr, Node node) {
        try {
            Node resultNode = (Node)expr.evaluate(node, XPathConstants.NODE);
            return resultNode;
        }
        catch (XPathExpressionException ex) {
            throw new RuleEvaluationException(ex.getMessage(), ex);
        }
    }
}

