/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.controllers;

import eu.dnetlib.validator.api.response.IssueDescriptorDto;
import eu.dnetlib.validator.api.response.SummaryResultDto;
import eu.dnetlib.validator.api.response.ValidationJobDto;
import eu.dnetlib.validatorapi.mapper.ValidationJobMapper;
import eu.dnetlib.validatorapi.service.SummaryValidationJobService;
import eu.dnetlib.validatorapi.service.ValidationIssueService;
import eu.dnetlib.validatorapi.service.ValidationJobService;
import eu.dnetlib.validatorapi.service.ValidationResultService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/reports"})
public class ReportController {
    @Autowired
    ValidationJobMapper validationJobMapper;
    private final ValidationJobService validationJobService;
    private final ValidationResultService validationResultService;
    private final ValidationIssueService validationIssueService;
    private final SummaryValidationJobService summaryValidationJobService;

    public ReportController(ValidationJobService validationJobService, ValidationResultService validationResultService, ValidationIssueService validationIssueService, SummaryValidationJobService summaryValidationJobService) {
        this.validationJobService = validationJobService;
        this.validationResultService = validationResultService;
        this.validationIssueService = validationIssueService;
        this.summaryValidationJobService = summaryValidationJobService;
    }

    @GetMapping(value={"getJobResult"}, produces={"application/json"})
    public ValidationJobDto getJobResults(@RequestParam(name="jobId") int jobId) {
        return this.validationJobService.findById(jobId).orElse(null);
    }

    @RequestMapping(value={"getResultsByJobId"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<SummaryResultDto> getSummaryJobResults(@RequestParam(name="jobId") int jobId, @RequestParam(name="guidelines", required=false) Optional<String> guidelines) {
        if (guidelines.isPresent() && guidelines.get().isEmpty()) {
            return this.validationResultService.getFullSummaryResult(jobId, guidelines.get());
        }
        return this.validationResultService.getFullSummaryResult(jobId);
    }

    @RequestMapping(value={"saveResultsByJobId"}, method={RequestMethod.GET}, produces={"application/json"})
    public void saveSummaryJobResults(@RequestParam(name="jobId") int jobId, @RequestParam(name="guidelines", required=false) Optional<String> guidelines) {
        List summaryResultList = guidelines.isPresent() && guidelines.get().isEmpty() ? this.validationResultService.getFullSummaryResult(jobId, guidelines.get()) : this.validationResultService.getFullSummaryResult(jobId);
        for (SummaryResultDto sr : summaryResultList) {
            System.out.println("Saving " + sr.getRuleName() + ", " + sr.getValidationJobId());
            sr.setValidationJobId(jobId);
            this.summaryValidationJobService.save(sr);
        }
    }

    @RequestMapping(value={"getSummaryFromDB"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<SummaryResultDto> getSummaryFromDB(@RequestParam(name="jobId") int jobId, @RequestParam(name="guidelines", required=false) Optional<String> guidelines) {
        return this.summaryValidationJobService.findByValidationJobIdOrderByRuleName(jobId);
    }

    @RequestMapping(value={"getWarningsReport"}, method={RequestMethod.GET}, produces={"application/json"})
    private List<IssueDescriptorDto> getWarningDescriptors(@RequestParam(name="jobId") int jobId, @RequestParam(name="ruleName") String ruleName) {
        return this.validationIssueService.getAllWarningsRecordUrlsByRuleName(jobId, ruleName);
    }

    @RequestMapping(value={"getErrorsReport"}, method={RequestMethod.GET}, produces={"application/json"})
    private List<IssueDescriptorDto> getErrorDescriptors(@RequestParam(name="jobId") int jobId, @RequestParam(name="ruleName") String ruleName) {
        return this.validationIssueService.getAllErrorsRecordUrlsByRuleName(jobId, ruleName);
    }
}

