/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.validator.api.request.ValidationRequest;
import eu.dnetlib.validator.api.response.ValidationJobDto;
import eu.dnetlib.validator.api.response.ValidationResponse;
import eu.dnetlib.validator.domain.Progress;
import eu.dnetlib.validator.domain.Status;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validatorapi.entities.ValidationJob;
import eu.dnetlib.validatorapi.entities.ValidationRuleResult;
import eu.dnetlib.validatorapi.exceptions.ValidationException;
import eu.dnetlib.validatorapi.mapper.ValidationJobMapper;
import eu.dnetlib.validatorapi.repositories.SummaryValidationJobRepository;
import eu.dnetlib.validatorapi.repositories.ValidationIssueRepository;
import eu.dnetlib.validatorapi.repositories.ValidationJobRepository;
import eu.dnetlib.validatorapi.repositories.ValidationResultRepository;
import eu.dnetlib.validatorapi.service.ValidationJobService;
import eu.dnetlib.validatorapi.utils.CheckCertificate;
import eu.dnetlib.validatorapi.utils.PrefixInitializer;
import eu.dnetlib.validatorapi.utils.ProfileInitializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@CrossOrigin(origins={"*"})
public class ValidationController {
    @Autowired
    private ValidationJobService validationJobService;
    @Autowired
    private ValidationJobMapper validationJobMapper;
    @Autowired
    private ProducerTemplate producerTemplate;
    private final Logger log = LogManager.getLogger(this.getClass());
    private final ValidationJobRepository validationJobRepository;
    private final ValidationResultRepository validationResultRepository;
    private final ValidationIssueRepository validationIssueRepository;
    private final SummaryValidationJobRepository summaryValidationJobRepository;
    @Autowired
    CamelContext camelContext;

    @Autowired
    public ValidationController(ValidationJobRepository validationJobRepository, ValidationResultRepository validationResultRepository, ValidationIssueRepository validationIssueRepository, SummaryValidationJobRepository summaryValidationJobRepository) {
        this.validationJobRepository = validationJobRepository;
        this.validationResultRepository = validationResultRepository;
        this.validationIssueRepository = validationIssueRepository;
        this.summaryValidationJobRepository = summaryValidationJobRepository;
    }

    @RequestMapping(value={"/validateRepository"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<ValidationJobDto> validateRepository(@ModelAttribute ValidationRequest validationRequest) {
        String guidelinesProfileName = validationRequest.getGuidelines();
        String baseURL = validationRequest.getBaseUrl();
        String set = validationRequest.getSet();
        int numberOfRecords = validationRequest.getNumberOfRecords();
        AbstractOpenAireProfile profile = ProfileInitializer.initializeOpenAireProfile((String)guidelinesProfileName);
        AbstractOpenAireProfile fairProfile = ProfileInitializer.initializeFairProfileByGuideline((String)guidelinesProfileName);
        String metadataPrefix = PrefixInitializer.initializeMetadataPrefix((String)guidelinesProfileName);
        ValidationJobDto validationJobDto = ValidationJobDto.builder().guidelines(profile.name()).baseUrl(validationRequest.getBaseUrl()).set((String)Optional.ofNullable(validationRequest.getSet()).orElse(null)).ruleIds(validationRequest.getRuleIds()).numberOfRecords(numberOfRecords).startDate(new Date()).hasFair(Boolean.valueOf(fairProfile != null)).progress(Progress.IN_PROGRESS).build();
        validationJobDto = this.validationJobService.save(validationJobDto);
        ValidationJob validationJob = this.validationJobMapper.toValidationJob(validationJobDto);
        double resultSum = 0.0;
        try {
            if (new URL(baseURL).getProtocol().equalsIgnoreCase("https") && !CheckCertificate.isValidCertificate((String)baseURL)) {
                this.updateValidationJobDto(Progress.STOPPED, "The SSL certificate could not be validated.", validationJobDto, resultSum);
                this.validationJobService.save(validationJobDto);
                return ResponseEntity.status((int)200).body((Object)validationJobDto);
            }
            String oaiEndpoint = ValidationController.generateListRecordOaiUrl((String)baseURL, (String)metadataPrefix, (String)set);
            System.out.println("Endpoint: " + oaiEndpoint);
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("oaiEndpoint", oaiEndpoint);
            headers.put("Profile", profile);
            headers.put("ValidationJob", validationJob);
            headers.put("NumberOfRecords", validationRequest.getNumberOfRecords());
            headers.put("adjustedNumberOfRecords", validationRequest.getNumberOfRecords() - 1);
            this.producerTemplate.asyncSend("seda:oaipmh", exchange -> {
                exchange.getIn().setBody(null);
                exchange.getIn().setHeaders(headers);
            });
            if (fairProfile != null) {
                HashMap<String, Object> fairHeaders = new HashMap<String, Object>(headers);
                fairHeaders.put("Profile", fairProfile);
                fairHeaders.put("isFair", true);
                this.producerTemplate.asyncSend("seda:oaipmh", exchange -> {
                    exchange.getIn().setBody(null);
                    exchange.getIn().setHeaders(fairHeaders);
                });
            }
        }
        catch (Exception e) {
            System.out.println("Validation job stopped unexpectedly. " + e.getMessage());
            this.updateValidationJobDto(Progress.STOPPED, e.getMessage(), validationJobDto, resultSum);
            validationJobDto = this.validationJobService.save(validationJobDto);
            return ResponseEntity.status((int)422).body((Object)validationJobDto);
        }
        return ResponseEntity.ok((Object)validationJobDto);
    }

    public static String generateListRecordOaiUrl(String baseURL, String metadataPrefix, String set) {
        String oaiEndpoint = baseURL + "?verb=ListRecords&metadataPrefix=" + metadataPrefix;
        if (set != null) {
            oaiEndpoint = oaiEndpoint + "&set=" + set;
        }
        return oaiEndpoint;
    }

    private void updateValidationJobDto(Progress progress, String exceptionMessage, ValidationJobDto validationJob, double resultSum) {
        validationJob.progress = progress;
        validationJob.endDate = new Date();
        validationJob.score = resultSum / (double)validationJob.recordsTested;
        validationJob.status = Status.valueOf((String)this.validationResultRepository.getStatus(validationJob.id).toUpperCase());
        validationJob.exceptionMessage = exceptionMessage;
    }

    private void checkProfile(AbstractOpenAireProfile profile, AbstractOpenAireProfile fairProfile, String guidelinesProfileName) {
        if (profile == null && fairProfile == null) {
            this.log.error("Exception: No valid guidelines " + guidelinesProfileName + ".");
            throw new ValidationException("Validation Job stopped unexpectedly. No valid guidelines " + guidelinesProfileName + " were provided.");
        }
    }

    @RequestMapping(value={"/validate"})
    private ValidationResponse getTestResult(@ModelAttribute ValidationRequest validationRequest) {
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        ValidationJob validationJob = new ValidationJob(validationRequest.getBaseUrl(), null, 1);
        validationJob.guidelines = validationRequest.getGuidelines();
        validationJob.ruleIds = Optional.ofNullable(validationRequest.getRuleIds()).orElse(Collections.emptyList()).toArray(new String[0]);
        AbstractOpenAireProfile profile = ProfileInitializer.initializeOpenAireProfile((String)validationJob.guidelines);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("oaiEndpoint", validationRequest.getBaseUrl());
        headers.put("NumberOfRecords", 1);
        headers.put("ValidationJob", validationJob);
        headers.put("Profile", profile);
        System.out.println("Here I am profile: " + String.valueOf(profile) + " and ruleIds");
        Map response = (Map)producerTemplate.requestBodyAndHeaders("direct:oai", null, headers, Map.class);
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(((ValidationResponse)mapper.convertValue((Object)response, ValidationResponse.class)).getIssues());
        return (ValidationResponse)mapper.convertValue((Object)response, ValidationResponse.class);
    }

    @RequestMapping(value={"/getSets"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<String> getSets(@RequestParam(name="baseUrl", defaultValue="http://repositorium.sdum.uminho.pt/oai/request") String baseURL) throws Exception {
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        Exchange message = producerTemplate.request("direct:getResponse", exchange -> exchange.getMessage().setHeader("endpoint", (Object)("oaipmh://" + baseURL + "?verb=ListSets")));
        return ResponseEntity.status((int)((Integer)message.getIn().getHeader("CamelHttpResponseCode", (Object)200, Integer.class))).body((Object)((String)message.getIn().getBody(String.class)));
    }

    @RequestMapping(value={"/validateRepositoryRecord"}, method={RequestMethod.GET})
    public ResponseEntity<ValidationJobDto> validateRepositoryRecord(@ModelAttribute ValidationRequest validationRequest) {
        String guidelinesProfileName = validationRequest.getGuidelines();
        String baseURL = validationRequest.getBaseUrl();
        int numberOfRecords = 1;
        AbstractOpenAireProfile profile = ProfileInitializer.initializeOpenAireProfile((String)guidelinesProfileName);
        ValidationJobDto validationJobDto = ValidationJobDto.builder().guidelines(profile.name()).baseUrl(validationRequest.getBaseUrl()).set((String)Optional.ofNullable(validationRequest.getSet()).orElse(null)).ruleIds(validationRequest.getRuleIds()).numberOfRecords(numberOfRecords).startDate(new Date()).progress(Progress.IN_PROGRESS).build();
        validationJobDto = this.validationJobService.save(validationJobDto);
        ValidationJob validationJob = this.validationJobMapper.toValidationJob(validationJobDto);
        double resultSum = 0.0;
        try {
            if (new URL(baseURL).getProtocol().equalsIgnoreCase("https") && !CheckCertificate.isValidCertificate((String)baseURL)) {
                this.updateValidationJobDto(Progress.STOPPED, "The SSL certificate could not be validated.", validationJobDto, resultSum);
                this.validationJobService.save(validationJobDto);
                return ResponseEntity.status((int)200).body((Object)validationJobDto);
            }
            String oaiEndpoint = baseURL;
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("oaiEndpoint", oaiEndpoint);
            headers.put("Profile", profile);
            headers.put("ValidationJob", validationJob);
            headers.put("NumberOfRecords", numberOfRecords);
            headers.put("adjustedNumberOfRecords", numberOfRecords - 1);
            this.producerTemplate.asyncSend("seda:oaipmh", exchange -> {
                exchange.getIn().setBody(null);
                exchange.getIn().setHeaders(headers);
            });
        }
        catch (Exception e) {
            this.log.error("Validation job stopped unexpectedly. ", (Throwable)e);
            this.updateValidationJobDto(Progress.STOPPED, e, validationJobDto, resultSum);
            validationJobDto = this.validationJobService.save(validationJobDto);
            return ResponseEntity.status((int)422).body((Object)validationJobDto);
        }
        return ResponseEntity.ok((Object)validationJobDto);
    }

    private void updateValidationJobDto(Progress progress, Exception exception, ValidationJobDto validationJobDto, double resultSum) {
        validationJobDto.progress = progress;
        validationJobDto.endDate = new Date();
        validationJobDto.score = resultSum / (double)validationJobDto.recordsTested;
        validationJobDto.status = Status.valueOf((String)this.validationResultRepository.getStatus(validationJobDto.id).toUpperCase());
        validationJobDto.exceptionClass = exception.getClass().getCanonicalName();
        validationJobDto.exceptionMessage = exception.getMessage();
    }

    private String extractRecordUrl(Document doc, String xmlField) {
        NodeList identifierNodes = doc.getElementsByTagName(xmlField);
        if (identifierNodes.getLength() > 0) {
            Element identifierElement = (Element)identifierNodes.item(0);
            return identifierElement.getTextContent();
        }
        return "-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/validateOAIPMH"}, method={RequestMethod.POST})
    public void validateOAIPMH(@RequestParam(name="guidelines") String guidelinesProfileName, @RequestParam(name="baseUrl", defaultValue="localhost") String baseUrl, @RequestParam(name="numberOfRecords", defaultValue="10") int numberOfRecords, @RequestBody String OAIPMHResponse) {
        ValidationJob validationJob = new ValidationJob(baseUrl, null, numberOfRecords);
        ArrayList resultRules = null;
        Object fairRules = null;
        AbstractOpenAireProfile profile = ProfileInitializer.initializeOpenAireProfile((String)guidelinesProfileName);
        AbstractOpenAireProfile fairProfile = ProfileInitializer.initializeFairProfileByGuideline((String)guidelinesProfileName);
        validationJob.guidelines = profile.name();
        this.validationJobRepository.save((Object)validationJob);
        this.log.info("Initial validation job id " + validationJob.id);
        int record = 0;
        double resultSum = 0.0;
        try {
            List recordXmls = this.extractRecordXmls(OAIPMHResponse);
            ArrayList<ValidationRuleResult> validationRuleResults = new ArrayList<ValidationRuleResult>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            for (String recordXml : recordXmls) {
                Document doc = db.parse(new InputSource(new StringReader(recordXml)));
                if (profile != null) {
                    resultRules = new ArrayList();
                    StandardValidationResult validationResult = profile.validate("id", doc);
                    Map results = validationResult.getResults();
                    for (Map.Entry entry : results.entrySet()) {
                        ValidationRuleResult validationRuleResult = new ValidationRuleResult();
                        validationRuleResult.validationJobId = validationJob.id;
                        validationRuleResult.ruleName = entry.getKey().toString();
                        validationRuleResult.recordUrl = "localhost://records/record[" + record + "]";
                        StandardResult engineResult = (StandardResult)entry.getValue();
                        validationRuleResult.score = engineResult.getScore();
                        validationRuleResult.status = engineResult.getStatus().toString();
                        validationRuleResult.internalError = engineResult.getInternalError();
                        System.out.println(String.valueOf(validationRuleResult) + " | " + validationRuleResult.hashCode() + "\n");
                        this.validationResultRepository.save((Object)validationRuleResult);
                        validationRuleResults.add(validationRuleResult);
                        resultSum += (double)engineResult.getScore();
                    }
                }
                ++record;
            }
            validationJob.progress = Progress.COMPLETED;
        }
        catch (Exception e) {
            this.log.error("Validation job stopped unexpectedly. " + e.getMessage());
            validationJob.progress = Progress.STOPPED;
            validationJob.exceptionClass = e.getClass().getCanonicalName();
            validationJob.exceptionMessage = e.getMessage();
        }
        finally {
            validationJob.endDate = new Date();
            this.log.info("Final validation job " + validationJob.id);
            validationJob.recordsTested = record;
            validationJob.score = resultSum / (double)record;
            this.validationJobRepository.save((Object)validationJob);
        }
    }

    public List<String> extractRecordXmls(String xml) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(new InputSource(new StringReader(xml)));
        XPathFactory xfactory = XPathFactory.newInstance();
        XPath xpath = xfactory.newXPath();
        XPathExpression recordsExpression = xpath.compile("//record");
        NodeList recordNodes = (NodeList)recordsExpression.evaluate(doc, XPathConstants.NODESET);
        ArrayList<String> records = new ArrayList<String>();
        for (int i = 0; i < recordNodes.getLength(); ++i) {
            Node element = recordNodes.item(i);
            StringWriter stringWriter = new StringWriter();
            Transformer xform = TransformerFactory.newInstance().newTransformer();
            xform.setOutputProperty("omit-xml-declaration", "yes");
            xform.setOutputProperty("indent", "yes");
            xform.transform(new DOMSource(element), new StreamResult(stringWriter));
            records.add(stringWriter.toString());
        }
        return records;
    }

    public static String formattedUrlWithMetadataPrefix(String url, String newMetadataPrefix) {
        try {
            URI uri = new URI(url);
            String query = uri.getQuery();
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            if (query != null) {
                for (String param : query.split("&")) {
                    int idx = param.indexOf(61);
                    String key = idx > 0 ? param.substring(0, idx) : param;
                    String value = idx > 0 && param.length() > idx + 1 ? param.substring(idx + 1) : "";
                    params.put(key, value);
                }
            }
            params.put("metadataPrefix", newMetadataPrefix);
            StringBuilder newQuery = new StringBuilder();
            for (Map.Entry entry : params.entrySet()) {
                if (newQuery.length() > 0) {
                    newQuery.append("&");
                }
                newQuery.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            URI newUri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), newQuery.toString(), uri.getFragment());
            return newUri.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }
}

