/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.processors;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SetsProcessor
implements Processor {
    private final Logger log = LogManager.getLogger(this.getClass());

    public void process(Exchange exchange) throws Exception {
        List messages = (List)exchange.getIn().getBody(ArrayList.class);
        if (exchange.getIn().getBody() == null) {
            throw new TimeoutException();
        }
        List ListSetsXml = (List)exchange.getIn().getBody(ArrayList.class);
        ArrayList desiredJsonParts = new ArrayList();
        Object xmlSets = "";
        for (String xml : ListSetsXml) {
            List extractedSets = this.extractSets(xml);
            for (String setXml : extractedSets) {
                xmlSets = (String)xmlSets + setXml;
            }
        }
        JSONObject jsonObject = XML.toJSONObject((String)xmlSets);
        String jsonString = jsonObject.toString();
        exchange.getIn().setHeader("CamelHttpResponseCode", (Object)200);
        exchange.getIn().setBody((Object)jsonString);
    }

    private List<String> extractSets(String xml) {
        ArrayList<String> setXmls = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(xml));
            Document document = builder.parse(inputSource);
            NodeList setElements = document.getElementsByTagName("set");
            for (int i = 0; i < setElements.getLength(); ++i) {
                Node setElement = setElements.item(i);
                String setXml = this.nodeToString(setElement);
                setXmls.add(setXml);
            }
        }
        catch (Exception e) {
            this.log.error("Could not parse the xml ", (Throwable)e);
        }
        return setXmls;
    }

    private String nodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }
}

