/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.processors;

import eu.dnetlib.validator.domain.Progress;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validatorapi.entities.SummaryResult;
import eu.dnetlib.validatorapi.entities.ValidationJob;
import eu.dnetlib.validatorapi.repositories.SummaryValidationJobRepository;
import eu.dnetlib.validatorapi.repositories.ValidationJobRepository;
import eu.dnetlib.validatorapi.repositories.ValidationResultRepository;
import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumUpNCleanProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(SumUpNCleanProcessor.class);
    private final ValidationJobRepository validationJobRepository;
    private final ValidationResultRepository validationResultRepository;
    private final SummaryValidationJobRepository summaryValidationJobRepository;
    private final AbstractOpenAireProfile profile;

    public SumUpNCleanProcessor(ValidationJobRepository validationJobRepository, ValidationResultRepository validationResultRepository, SummaryValidationJobRepository summaryValidationJobRepository, AbstractOpenAireProfile profile) {
        this.validationJobRepository = validationJobRepository;
        this.validationResultRepository = validationResultRepository;
        this.summaryValidationJobRepository = summaryValidationJobRepository;
        this.profile = profile;
    }

    public void process(Exchange exchange) throws Exception {
        ValidationJob validationJob = (ValidationJob)exchange.getIn().getHeader("ValidationJob");
        validationJob.progress = Progress.COMPLETED;
        validationJob.endDate = new Date();
        List summaryResults = this.validationResultRepository.getFullSummaryResult(validationJob.id, validationJob.guidelines);
        for (SummaryResult sr : summaryResults) {
            sr.validationJobId = validationJob.id;
            this.summaryValidationJobRepository.save((Object)sr);
        }
        this.validationJobRepository.save((Object)validationJob);
    }
}

