/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.processors;

import eu.dnetlib.validator.domain.Status;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.result_models.ValidationProblem;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validatorapi.entities.ValidationIssue;
import eu.dnetlib.validatorapi.entities.ValidationJob;
import eu.dnetlib.validatorapi.entities.ValidationRuleResult;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component
public class XmlProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(XmlProcessor.class);

    public void process(Exchange exchange) throws Exception {
        String status = "SUCCESS";
        int scoreSum = 0;
        System.out.println(">> " + (Integer)exchange.getProperty("CamelSplitIndex") + "1");
        AbstractOpenAireProfile profile = (AbstractOpenAireProfile)exchange.getIn().getHeader("Profile", AbstractOpenAireProfile.class);
        Boolean isFair = (Boolean)exchange.getIn().getHeader("isFair", Boolean.class);
        ValidationJob validationJob = (ValidationJob)exchange.getIn().getHeader("ValidationJob", ValidationJob.class);
        Long maxNumberOfRecords = (Long)exchange.getIn().getHeader("NumberOfRecords", Long.class);
        int processedRecords = 1;
        if (exchange.getProperty("CamelSplitIndex") != null) {
            processedRecords = (Integer)exchange.getProperty("CamelSplitIndex") + 1;
        }
        String recordXml = (String)exchange.getIn().getBody(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        Document doc = documentBuilder.parse(new InputSource(new StringReader(recordXml)));
        String recordUrl = this.extractRecordUrl(doc, "identifier");
        System.out.println(processedRecords + ". recordUrl: " + recordUrl);
        ArrayList<ValidationRuleResult> validationRuleResults = new ArrayList<ValidationRuleResult>();
        ArrayList<ValidationIssue> validationIssues = new ArrayList<ValidationIssue>();
        if (profile != null) {
            StandardValidationResult validationResult = null;
            validationResult = validationJob.ruleIds != null && validationJob.ruleIds.length > 0 ? profile.validate("id", Arrays.asList(validationJob.ruleIds), doc) : profile.validate("id", doc);
            Map results = validationResult.getResults();
            for (Map.Entry entry : results.entrySet()) {
                StandardResult engineResult = (StandardResult)entry.getValue();
                String ruleName = entry.getKey().toString();
                String ruleId = profile.guideline(ruleName).getFairRuleId();
                ValidationRuleResult validationRuleResult = new ValidationRuleResult();
                this.constructValidationRuleResult(validationRuleResult, validationJob.id, profile.name(), recordUrl, ruleName, ruleId, profile, engineResult);
                if (validationRuleResult.status.equals("FAILURE") || validationRuleResult.internalError != null) {
                    status = "FAILURE";
                }
                if (engineResult.getErrors() != null && engineResult.getErrors().iterator().hasNext()) {
                    validationRuleResult.hasErrors = true;
                    for (ValidationProblem error : engineResult.getErrors()) {
                        validationIssues.add(new ValidationIssue(validationJob.id, ruleName, ruleId, recordUrl, error.getMessage(), error.getSuggestion(), "ERROR"));
                    }
                }
                if (engineResult.getWarnings() != null && engineResult.getWarnings().iterator().hasNext()) {
                    validationRuleResult.hasWarnings = true;
                    for (ValidationProblem warning : engineResult.getWarnings()) {
                        validationIssues.add(new ValidationIssue(validationJob.id, ruleName, ruleId, recordUrl, warning.getMessage(), warning.getSuggestion(), "WARNING"));
                    }
                }
                validationRuleResults.add(validationRuleResult);
                scoreSum += engineResult.getScore();
            }
        }
        HashMap<String, ArrayList<Object>> resultsMap = new HashMap<String, ArrayList<Object>>();
        resultsMap.put("results", validationRuleResults);
        resultsMap.put("issues", validationIssues);
        exchange.getIn().setBody(resultsMap, Map.class);
        exchange.getIn().setHeader("maxNumberOfRecords", (Object)maxNumberOfRecords);
        exchange.getIn().setHeader("isFair", (Object)(isFair != null && isFair != false ? 1 : 0));
        this.finalValidationJobUpdate(validationJob, status, processedRecords, scoreSum, maxNumberOfRecords.longValue());
        exchange.getIn().setHeader("ValidationJob", (Object)validationJob);
    }

    private void finalValidationJobUpdate(ValidationJob validationJob, String status, int processedRecords, int scoreSum, long maxNumberOfRecords) {
        validationJob.status = Status.valueOf((String)status.toUpperCase());
        validationJob.recordsTested = processedRecords;
        validationJob.numberOfRecords = Math.toIntExact(maxNumberOfRecords);
        validationJob.score = scoreSum / processedRecords;
    }

    private String extractRecordUrl(Document document, String xmlField) {
        NodeList identifierNodes = document.getElementsByTagName(xmlField);
        if (identifierNodes.getLength() > 0) {
            Element identifierElement = (Element)identifierNodes.item(0);
            return identifierElement.getTextContent();
        }
        return "-";
    }

    private void constructValidationRuleResult(ValidationRuleResult validationRuleResult, int validationJobId, String guidelines, String recordUrl, String ruleName, String ruleId, AbstractOpenAireProfile profile, StandardResult engineResult) {
        validationRuleResult.validationJobId = validationJobId;
        validationRuleResult.guidelines = guidelines;
        validationRuleResult.ruleName = ruleName;
        validationRuleResult.ruleId = ruleId;
        if (profile.guideline(ruleName) != null) {
            validationRuleResult.ruleWeight = profile.guideline(ruleName).getWeight();
            if (profile.guideline(ruleName).getRequirementLevel() != null && profile.guideline(ruleName).getRequirementLevel().name() != null) {
                validationRuleResult.requirement_level = profile.guideline(ruleName).getRequirementLevel().name();
            }
            if (profile.guideline(ruleName).getDescription() != null) {
                validationRuleResult.description = profile.guideline(ruleName).getDescription();
            }
            if (profile.guideline(ruleName).getFairPrinciples() != null) {
                validationRuleResult.fair_principles = profile.guideline(ruleName).getFairPrinciples();
            }
            if (profile.guideline(ruleName).getLink() != null) {
                validationRuleResult.link = profile.guideline(ruleName).getLink();
            }
        }
        validationRuleResult.recordUrl = recordUrl;
        validationRuleResult.score = engineResult.getScore();
        validationRuleResult.status = engineResult.getStatus().toString();
        validationRuleResult.internalError = engineResult.getInternalError();
    }
}

