/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.utils;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OaipmhParser {
    private static final Logger log = LoggerFactory.getLogger(OaipmhParser.class);
    private static DocumentBuilderFactory factory;
    private static DocumentBuilder documentBuilder;

    OaipmhParser(DocumentBuilderFactory factory, DocumentBuilder documentBuilder) throws ParserConfigurationException {
        OaipmhParser.factory = DocumentBuilderFactory.newInstance();
        OaipmhParser.documentBuilder = factory.newDocumentBuilder();
    }

    public static boolean isOaipmhErrorXML(String xml) {
        try {
            Document doc = documentBuilder.parse(new InputSource(new StringReader(xml)));
            Element rootElement = doc.getDocumentElement();
            return "OAI-PMH".equals(rootElement.getLocalName()) || doc.getElementsByTagName("error").getLength() >= 1;
        }
        catch (Exception e) {
            log.warn("The returned error is not an OAI-PMH XML");
            return false;
        }
    }

    public static String parseError(String xml) {
        try {
            Document doc = documentBuilder.parse(new InputSource(new StringReader(xml)));
            doc.getDocumentElement().normalize();
            NodeList errorList = doc.getElementsByTagName("error");
            if (errorList.getLength() > 0) {
                Element errorElement = (Element)errorList.item(0);
                String errorCode = errorElement.getAttribute("code");
                String errorMessage = errorElement.getTextContent();
                String refinedErrorMessage = "The repository returns error: '" + errorCode + " : " + errorMessage + "'. The complete XML response of the  repository is : " + xml;
                return refinedErrorMessage;
            }
            return xml;
        }
        catch (Exception e) {
            log.warn("Error in parcing OAI-PMH error response");
            return xml;
        }
    }
}

