/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.utils;

import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.DataArchiveGuidelinesV2Profile;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Data_GuidelinesProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Literature_GuidelinesV3Profile;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Literature_GuidelinesV4Profile;
import eu.dnetlib.validator2.validation.guideline.openaire.LiteratureGuidelinesV3Profile;
import eu.dnetlib.validator2.validation.guideline.openaire.LiteratureGuidelinesV4Profile;

public class ProfileInitializer {
    public static AbstractOpenAireProfile initializeOpenAireProfile(String guidelinesProfileName) {
        System.out.println("Initializing OpenAire Profile: " + guidelinesProfileName);
        if (guidelinesProfileName.equals("OpenAIRE Guidelines for Data Archives Profile v2")) {
            return new DataArchiveGuidelinesV2Profile();
        }
        if (guidelinesProfileName.equals("OpenAIRE Guidelines for Literature Repositories Profile v3")) {
            return new LiteratureGuidelinesV3Profile();
        }
        if (guidelinesProfileName.equals("OpenAIRE Guidelines for Literature Repositories Profile v4")) {
            return new LiteratureGuidelinesV4Profile();
        }
        if (guidelinesProfileName.equals("OpenAIRE FAIR Guidelines for Data Repositories Profile")) {
            return new FAIR_Data_GuidelinesProfile();
        }
        if (guidelinesProfileName.equals("OpenAIRE FAIR Guidelines for Literature Repositories Profile v4")) {
            return new FAIR_Literature_GuidelinesV4Profile();
        }
        return null;
    }

    public static AbstractOpenAireProfile initializeFairProfileByGuideline(String guidelinesProfileName) {
        System.out.println("Initializing Fair Profile: " + guidelinesProfileName);
        if (guidelinesProfileName.equals("OpenAIRE Guidelines for Data Archives Profile v2")) {
            return new FAIR_Data_GuidelinesProfile();
        }
        if (guidelinesProfileName.equals("OpenAIRE Guidelines for Literature Repositories Profile v3")) {
            return new FAIR_Literature_GuidelinesV3Profile();
        }
        if (guidelinesProfileName.equals("OpenAIRE Guidelines for Literature Repositories Profile v4")) {
            return new FAIR_Literature_GuidelinesV4Profile();
        }
        return null;
    }

    public static AbstractOpenAireProfile initializeFairProfileByName(String fairProfileName) {
        System.out.println("Initializing fair profile by name : " + fairProfileName);
        if (fairProfileName.equals("OpenAIRE FAIR Guidelines for Data Repositories Profile")) {
            return new FAIR_Data_GuidelinesProfile();
        }
        if (fairProfileName.equals("OpenAIRE FAIR Guidelines for Literature Repositories Profile v4")) {
            return new FAIR_Literature_GuidelinesV4Profile();
        }
        return null;
    }

    public static AbstractOpenAireProfile initializeFairProfileByType(String type) {
        if (type.equals("data")) {
            return new FAIR_Data_GuidelinesProfile();
        }
        if (type.equals("literature")) {
            return new FAIR_Literature_GuidelinesV4Profile();
        }
        return null;
    }
}

