/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.common.author;

import eu.openaire.common.author.AuthorMatch;
import eu.openaire.common.author.AuthorMatcherStep;
import eu.openaire.common.author.OrderedTokenAndAbbreviationsMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class AuthorMatchers {
    public static boolean matchEqualsIgnoreCase(String a1, String a2) {
        if (a1 == null || a2 == null) {
            return false;
        }
        return a1 == a2 || a1.toLowerCase(Locale.ROOT).equals(a2.toLowerCase(Locale.ROOT));
    }

    public static Optional<Double> matchOrderedTokenAndAbbreviations(String a1, String a2) {
        return OrderedTokenAndAbbreviationsMatcher.compare(a1, a2);
    }

    public static List<String> removeMatches(List<String> base_authors, List<String> enriching_authors, BiFunction<String, String, Boolean> matchingFunc) {
        ArrayList<String> matched = new ArrayList<String>();
        if (base_authors != null && !base_authors.isEmpty()) {
            Iterator<String> ait = base_authors.iterator();
            block0: while (ait.hasNext()) {
                String base = ait.next();
                Iterator<String> oit = enriching_authors.iterator();
                while (oit.hasNext()) {
                    String enriching = oit.next();
                    if (!matchingFunc.apply(base, enriching).booleanValue()) continue;
                    ait.remove();
                    oit.remove();
                    matched.add(base);
                    matched.add(enriching);
                    continue block0;
                }
            }
        }
        return matched;
    }

    public static <BA, EA> List<AuthorMatch<BA, EA>> findMatches(List<BA> base_authors, List<EA> enrichment_authors, List<AuthorMatcherStep<BA, EA>> steps) {
        ArrayList<AuthorMatch<BA, EA>> result = new ArrayList<AuthorMatch<BA, EA>>();
        ArrayList<BA> unmatched_base_authors = new ArrayList<BA>(base_authors);
        ArrayList<EA> unmatched_enrichment_authors = new ArrayList<EA>(enrichment_authors);
        for (AuthorMatcherStep<BA, EA> s : steps) {
            result.addAll(AuthorMatchers.evaluateStep(unmatched_base_authors, unmatched_enrichment_authors, s));
        }
        return result;
    }

    private static <BA, EA> List<AuthorMatch<BA, EA>> evaluateStep(List<BA> unmatched_base_authors, List<EA> unmatched_enriching_authors, AuthorMatcherStep<BA, EA> step) {
        ArrayList matches = new ArrayList();
        if (unmatched_base_authors.isEmpty()) {
            return new ArrayList<AuthorMatch<BA, EA>>();
        }
        for (Object enriching_author : unmatched_enriching_authors) {
            List potential_matches = unmatched_base_authors.stream().map(x -> step.getMatchingFunc().apply(x, enriching_author)).filter(Optional::isPresent).map(Optional::get).sorted(Collections.reverseOrder(Comparator.comparingDouble(AuthorMatch::getConfidence))).collect(Collectors.toList());
            if (potential_matches.size() != 1 && (potential_matches.size() <= 1 || step.getExclusionPredicate() != null && step.getExclusionPredicate().test(potential_matches))) continue;
            matches.addAll(potential_matches);
        }
        HashSet matched_base_authors = new HashSet();
        HashSet matched_enrichment_authors = new HashSet();
        ArrayList<AuthorMatch<BA, EA>> results = new ArrayList<AuthorMatch<BA, EA>>();
        for (AuthorMatch m : matches.stream().sorted(Collections.reverseOrder(Comparator.comparingDouble(AuthorMatch::getConfidence))).collect(Collectors.toList())) {
            if (matched_base_authors.contains(m.getBaseAuthor()) || matched_enrichment_authors.contains(m.getEnrichingAuthor())) continue;
            matched_base_authors.add(m.getBaseAuthor());
            matched_enrichment_authors.add(m.getEnrichingAuthor());
            results.add(m);
        }
        unmatched_base_authors.removeAll(matched_base_authors);
        unmatched_enriching_authors.removeAll(matched_enrichment_authors);
        return results;
    }
}

