/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.controller;

import eu.openaire.openaire_ostrails_api.dto.Benchmark;
import eu.openaire.openaire_ostrails_api.dto.ResourceRequest;
import eu.openaire.openaire_ostrails_api.dto.TestResultSet;
import eu.openaire.openaire_ostrails_api.mapper.RDFMapper;
import eu.openaire.openaire_ostrails_api.service.BenchmarkService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/osTrails/benchmarks"})
@Tag(name="Benchmarks API")
public class BenchmarkController {
    @Autowired
    private BenchmarkService benchmarkService;
    RDFMapper rdfMapper = new RDFMapper();

    @GetMapping(value={"/"})
    public ResponseEntity<List<String>> listBenchmarksEndpoints(HttpServletRequest request) {
        return ResponseEntity.ok(this.benchmarkService.listProfileIds().stream().map(guideline -> request.getRequestURL().toString() + guideline).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{benchmarkId}"}, produces={"application/ld+json", "text/turtle"})
    public ResponseEntity<String> getBenchmark(HttpServletRequest request, @PathVariable String benchmarkId) {
        Benchmark benchmark = this.benchmarkService.getBenchmark(benchmarkId);
        if (benchmark == null) {
            return ResponseEntity.notFound().build();
        }
        benchmark.setUri(request.getRequestURL().toString());
        benchmark.setIdentifier(request.getRequestURL().toString());
        List prefixedMetrics = benchmark.getAssociatedMetric().stream().map(metric -> this.getMetricBaseUrl(request) + metric).collect(Collectors.toList());
        benchmark.setAssociatedMetric(prefixedMetrics);
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("text/turtle")) {
            String body = this.rdfMapper.toTurtle(benchmark);
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"text/turtle")).body((Object)body);
        }
        String body = this.rdfMapper.toJsonLd(benchmark);
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/ld+json")).body((Object)body);
    }

    @PostMapping(value={"/{benchmarkId}"}, produces={"application/ld+json", "text/turtle"})
    public ResponseEntity<String> runBenchmarkTest(HttpServletRequest request, @RequestBody ResourceRequest resource, @PathVariable String benchmarkId) {
        TestResultSet testResultSet = this.benchmarkService.validate(resource.getResourceIdentifier(), ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString());
        testResultSet.setId(request.getRequestURL().toString());
        testResultSet.setIdentifier(request.getRequestURL().toString());
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("text/turtle")) {
            String body = this.rdfMapper.toTurtle(testResultSet);
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"text/turtle")).body((Object)body);
        }
        String body = this.rdfMapper.toJsonLd(testResultSet);
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/ld+json")).body((Object)body);
    }

    private String getMetricBaseUrl(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        String contextPath = request.getContextPath();
        return requestURL.replace(request.getRequestURI(), "/osTrails/metrics/" + contextPath);
    }
}

