/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.mapper;

import eu.dnetlib.validator.api.response.ValidationResponse;
import eu.openaire.openaire_ostrails_api.dto.Advice;
import eu.openaire.openaire_ostrails_api.dto.GuidanceElement;
import eu.openaire.openaire_ostrails_api.dto.License;
import eu.openaire.openaire_ostrails_api.dto.TestResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestResultMapper {
    private static final Pattern REASON_PATTERN = Pattern.compile("reason:\\s*'(.*)'\\)", 32);

    public TestResult toTestResult(ValidationResponse.Result validationResult, List<ValidationResponse.Issue> issues) {
        TestResult result = new TestResult();
        result.setRuleId(validationResult.getRuleId());
        result.setTitle(validationResult.getRuleName());
        result.setDescription(validationResult.getDescription());
        result.setValue(validationResult.getStatus());
        result.setCompletion((int)(validationResult.getScore() * 100.0));
        result.setAssessmentTarget(validationResult.getRecordUrl());
        result.setEndpointURL(validationResult.getLink());
        if (issues != null) {
            result.setLog(this.buildLog(issues));
            result.setSuggestions(this.buildSuggestion(result, issues));
        }
        result.setLicense(License.builder().id("https://w3id.org/fair/license").build());
        System.out.println("\n\nTest Result: \n\n" + String.valueOf(result));
        return result;
    }

    private String buildLog(List<ValidationResponse.Issue> issues) {
        StringBuilder sb = new StringBuilder();
        for (ValidationResponse.Issue issue : issues) {
            sb.append("[").append(issue.getIssueType()).append("] ").append(issue.getIssueText()).append("\n");
        }
        return sb.toString().trim();
    }

    private List<Advice> buildSuggestion(TestResult testResult, List<ValidationResponse.Issue> issues) {
        ArrayList<Advice> suggestions = new ArrayList<Advice>();
        System.out.println("\n\nTest Result: \n\n" + testResult.getIdentifier());
        IntStream.range(0, issues.size()).forEach(i -> {
            ValidationResponse.Issue issue = (ValidationResponse.Issue)issues.get(i);
            Advice advice = new Advice();
            advice.setId(issue.getRuleId() + "_advice_" + (i + 1));
            GuidanceElement guidanceElement = new GuidanceElement();
            guidanceElement.setId(issue.getRuleId() + "_guidance_" + (i + 1));
            guidanceElement.setType(GuidanceElement.GuidanceType.RECOMMENDATION);
            guidanceElement.setCreatedBy("OpenAIRE FAIR Guidelines Community");
            advice.setSpecifiedBy(guidanceElement);
            advice.setLabel(TestResultMapper.extractReason((String)issue.getIssueText()));
            advice.setDescription(issue.getSuggestion());
            suggestions.add(advice);
        });
        System.out.println("\n\nSuggestions: \n\n" + String.valueOf(suggestions));
        return suggestions;
    }

    public static String extractReason(String message) {
        if (message == null) {
            return null;
        }
        Matcher m = REASON_PATTERN.matcher(message);
        if (m.find()) {
            return m.group(1).trim();
        }
        return null;
    }
}

