/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.service;

import eu.dnetlib.validator.api.request.ValidationRequest;
import eu.dnetlib.validator.api.response.ValidationResponse;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Data_GuidelinesProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Literature_GuidelinesV4Profile;
import eu.openaire.openaire_ostrails_api.dto.Test;
import eu.openaire.openaire_ostrails_api.dto.TestResult;
import eu.openaire.openaire_ostrails_api.mapper.TestMapper;
import eu.openaire.openaire_ostrails_api.mapper.TestResultMapper;
import eu.openaire.openaire_ostrails_api.service.ValidatorService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestService {
    private FAIR_Literature_GuidelinesV4Profile literatureProfile = new FAIR_Literature_GuidelinesV4Profile();
    private FAIR_Data_GuidelinesProfile dataProfile = new FAIR_Data_GuidelinesProfile();
    @Autowired
    ValidatorService validatorService;
    TestResultMapper testResultMapper = new TestResultMapper();

    public List<String> listGuidelineIds() {
        return this.dataProfile.guidelines().stream().map(guideline -> guideline.getFairRuleId()).collect(Collectors.toList());
    }

    public Test getTest(String testId) {
        return this.dataProfile.guidelines().stream().filter(guideline -> guideline.getFairRuleId().equalsIgnoreCase(testId)).findFirst().map(TestMapper::toTest).orElse(null);
    }

    public TestResult validate(String testId, String resourceIdentifier) {
        ValidationRequest validationRequest = new ValidationRequest();
        validationRequest.setGuidelines(this.dataProfile.name());
        validationRequest.setBaseUrl(resourceIdentifier);
        String ruleId = this.dataProfile.guidelines().stream().filter(guideline -> guideline.getFairRuleId().equalsIgnoreCase(testId)).findFirst().map(guideline -> guideline.getFairRuleId()).orElse(null);
        if (ruleId == null) {
            throw new IllegalArgumentException("A valid testId is expected.");
        }
        validationRequest.setRuleIds(Arrays.asList(ruleId));
        ValidationResponse validationResponse = this.validatorService.validate(validationRequest);
        if (validationResponse == null || validationResponse.getResults() == null || validationResponse.getResults().isEmpty()) {
            return null;
        }
        TestResult testResult = this.testResultMapper.toTestResult((ValidationResponse.Result)validationResponse.getResults().get(0), validationResponse.getIssues());
        return testResult;
    }
}

