/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Controller
public class ApiFormController {
    private final RequestMappingHandlerMapping handlerMapping;

    @Autowired
    public ApiFormController(@Qualifier(value="requestMappingHandlerMapping") RequestMappingHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
    }

    @GetMapping(value={"/forms"})
    public String apiForms(Model model) {
        ArrayList endpoints = new ArrayList();
        this.handlerMapping.getHandlerMethods().forEach((mapping, method) -> {
            Class<?> controllerClass = method.getMethod().getDeclaringClass();
            if (!controllerClass.getPackageName().startsWith("eu.openaire.openaire_ostrails_api.controller")) {
                return;
            }
            Set patterns = this.extractPatterns(mapping);
            mapping.getMethodsCondition().getMethods().forEach(requestMethod -> {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("method", requestMethod.name());
                info.put("path", String.join((CharSequence)", ", patterns));
                info.put("handler", method.getMethod().getDeclaringClass().getSimpleName() + "#" + method.getMethod().getName());
                endpoints.add(info);
            });
        });
        model.addAttribute("endpoints", endpoints);
        return "forms/test-forms";
    }

    private Set<String> extractPatterns(RequestMappingInfo mapping) {
        if (mapping.getPathPatternsCondition() != null) {
            return mapping.getPathPatternsCondition().getPatterns().stream().map(p -> p.getPatternString()).collect(Collectors.toSet());
        }
        if (mapping.getPatternsCondition() != null) {
            return mapping.getPatternsCondition().getPatterns();
        }
        return Set.of();
    }
}

