/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.action;

import com.googlecode.sarasvati.GraphProcess;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDFormatDescription;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.MDStoreUtils;
import eu.dnetlib.data.mdstore.modular.action.AbstractMDStoreAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class FeedAction
extends AbstractMDStoreAction {
    private static final Log log = LogFactory.getLog(FeedAction.class);
    private static final String layoutIndex = "store";
    private MDStoreFeeder feeder;
    @Autowired
    private MDStoreUtils mdstoreUtils;

    @Override
    public void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws MDStoreServiceException {
        String format;
        List<MDFormatDescription> mdformats;
        String mdId = (String)job.getParameters().get("mdId");
        if (mdId == null || mdId.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String epr = (String)job.getParameters().get("epr");
        if (epr == null || epr.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String storingType = (String)job.getParameters().get("storingType");
        if (storingType == null || storingType.isEmpty()) {
            storingType = "REFRESH";
        }
        if ((mdformats = this.mdstoreUtils.getField(format = this.feeder.getDao().getMDStore(mdId).getFormat(), layoutIndex)) != null) {
            for (MDFormatDescription desc : mdformats) {
                log.info((Object)("name: " + desc.getName()));
                log.info((Object)("xpath: " + desc.getXpath()));
            }
        }
        String processId = (String)job.getParameters().get("system:processId");
        GraphProcess proc = this.getGraphProcessRegistry().findProcess(processId);
        log.info((Object)String.format("feeding mdstore %s from workflow process %s", mdId, processId));
        this.feeder.feed(mdId, epr, storingType, true, mdformats, proc, params -> {
            job.getParameters().put("mdstoreSize", "" + (String)params.get("mdstoreSize"));
            job.getParameters().put("writeOps", "" + (String)params.get("writeOps"));
            this.completeWithSuccess(handler, job);
        }, (e, params) -> {
            log.error((Object)("Error feeding mdstore: " + mdId), e);
            job.getParameters().put("mdstoreSize", "" + (String)params.get("mdstoreSize"));
            job.getParameters().put("writeOps", "" + (String)params.get("writeOps"));
            this.completeWithFail(handler, job, e);
        });
    }

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    @Required
    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }
}

