/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ISClient
implements Serializable {
    public static final Logger log = LoggerFactory.getLogger(ISClient.class);
    private static final String INPUT_ACTION_SET_ID_SEPARATOR = ",";
    private final transient ISLookUpService isLookup;

    public ISClient(String isLookupUrl) {
        this.isLookup = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
    }

    public List<String> getLatestRawsetPaths(String setIds) {
        HashSet ids = Sets.newHashSet((Iterable)Splitter.on((String)INPUT_ACTION_SET_ID_SEPARATOR).omitEmptyStrings().trimResults().split((CharSequence)setIds));
        try {
            String basePath = this.getBasePathHDFS(this.isLookup);
            String xquery = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return <SET id='{$x//SET/@id/string()}' directory='{$x//SET/@directory/string()}' latest='{$x//LATEST/@id/string()}'/>";
            return Optional.ofNullable(this.isLookup.quickSearchProfile("for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return <SET id='{$x//SET/@id/string()}' directory='{$x//SET/@directory/string()}' latest='{$x//LATEST/@id/string()}'/>")).map(sets -> sets.stream().map(ISClient::parseSetInfo).filter(t -> ids.contains(t.getLeft())).map(t -> this.buildDirectory(basePath, (Triple<String, String, String>)t)).collect(Collectors.toList())).orElseThrow(() -> new IllegalStateException("empty set list"));
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("unable to query ActionSets info from the IS");
        }
    }

    private static Triple<String, String, String> parseSetInfo(String set) {
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document doc = reader.read((Reader)new StringReader(set));
            return Triple.of((Object)doc.valueOf("//SET/@id"), (Object)doc.valueOf("//SET/@directory"), (Object)doc.valueOf("//SET/@latest"));
        }
        catch (DocumentException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private String buildDirectory(String basePath, Triple<String, String, String> t) {
        return Joiner.on((String)"/").join((Object)basePath, t.getMiddle(), new Object[]{t.getRight()});
    }

    private String getBasePathHDFS(ISLookUpService isLookup) throws ISLookUpException {
        return this.queryServiceProperty(isLookup, "basePath");
    }

    private String queryServiceProperty(ISLookUpService isLookup, String propertyName) throws ISLookUpException {
        String q = "for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ActionManagerServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + propertyName + "']/@value/string()";
        log.debug("quering for service property: {}", (Object)q);
        List value = isLookup.quickSearchProfile(q);
        return (String)Iterables.getOnlyElement((Iterable)value);
    }
}

