/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.createunresolvedentities;

import eu.dnetlib.dhp.actionmanager.Constants;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.model.SDGDataModel;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapGroupsFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareSDGSparkJob
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PrepareSDGSparkJob.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareSDGSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/prepare_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Constants.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String sourcePath = parser.get("sourcePath");
        log.info("sourcePath: {}", (Object)sourcePath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> PrepareSDGSparkJob.doPrepare(spark, sourcePath, outputPath));
    }

    private static void doPrepare(SparkSession spark, String sourcePath, String outputPath) {
        Dataset<SDGDataModel> sdgDataset = Constants.readPath(spark, sourcePath, SDGDataModel.class);
        sdgDataset.groupByKey((MapFunction & Serializable)r -> r.getDoi().toLowerCase(), Encoders.STRING()).mapGroups((MapGroupsFunction & Serializable)(k, it) -> {
            Result r = new Result();
            r.setId(DHPUtils.generateUnresolvedIdentifier((String)k, (String)"doi"));
            SDGDataModel first = (SDGDataModel)it.next();
            ArrayList<Subject> sbjs = new ArrayList<Subject>();
            sbjs.add(Constants.getSubject(first.getSbj(), "SDG", "Sustainable Development Goals", "subject:sdg"));
            it.forEachRemaining(s -> sbjs.add(Constants.getSubject(s.getSbj(), "SDG", "Sustainable Development Goals", "subject:sdg")));
            r.setSubject(sbjs);
            r.setDataInfo(OafMapperUtils.dataInfo((Boolean)false, null, (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"sysimport:enrich", null, (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), null));
            return r;
        }, Encoders.bean(Result.class)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath + "/sdg");
    }
}

