/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.opencitations;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOpenCitationsRefs
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GetOpenCitationsRefs.class);

    public static void main(String[] args) throws IOException, ParseException {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(GetOpenCitationsRefs.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/opencitations/input_parameters.json"))));
        parser.parseArgument(args);
        String[] inputFile = parser.get("inputFile").split(";");
        log.info("inputFile {}", Arrays.asList(inputFile));
        String workingPath = parser.get("workingPath");
        log.info("workingPath {}", (Object)workingPath);
        String hdfsNameNode = parser.get("hdfsNameNode");
        log.info("hdfsNameNode {}", (Object)hdfsNameNode);
        String prefix = parser.get("prefix");
        log.info("prefix {}", (Object)prefix);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        GetOpenCitationsRefs ocr = new GetOpenCitationsRefs();
        for (String file : inputFile) {
            ocr.doExtract(workingPath + "/Original/" + file, workingPath, fileSystem, prefix);
        }
    }

    private void doExtract(String inputFile, String workingPath, FileSystem fileSystem, String prefix) throws IOException {
        Path path = new Path(inputFile);
        FSDataInputStream oc_zip = fileSystem.open(path);
        try (ZipInputStream zis = new ZipInputStream((InputStream)oc_zip);){
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
                FSDataOutputStream out = fileSystem.create(new Path(workingPath + "/" + prefix + "/" + fileName + ".gz"));
                Throwable throwable = null;
                try {
                    GZIPOutputStream gzipOs = new GZIPOutputStream(new BufferedOutputStream((OutputStream)out));
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)zis, (OutputStream)gzipOs);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (gzipOs == null) continue;
                        if (throwable2 != null) {
                            try {
                                gzipOs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        gzipOs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
    }
}

