/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.file;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.utils.XMLIterator;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSplittedRecordPlugin
implements CollectorPlugin {
    private static final Logger log = LoggerFactory.getLogger(AbstractSplittedRecordPlugin.class);
    public static final String SPLIT_ON_ELEMENT = "splitOnElement";
    private final FileSystem fileSystem;

    public AbstractSplittedRecordPlugin(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        Path filePath = Optional.ofNullable(api.getBaseUrl()).map(Path::new).orElseThrow(() -> new CollectorException("missing baseUrl"));
        log.info("baseUrl: {}", (Object)filePath);
        try {
            if (!this.fileSystem.exists(filePath)) {
                throw new CollectorException("path does not exist: " + filePath);
            }
        }
        catch (IOException e) {
            throw new CollectorException((Throwable)e);
        }
        String splitOnElement = (String)Optional.ofNullable(api.getParams().get(SPLIT_ON_ELEMENT)).orElseThrow(() -> new CollectorException(String.format("missing parameter '%s', required by the AbstractSplittedRecordPlugin", SPLIT_ON_ELEMENT)));
        log.info("splitOnElement: {}", (Object)splitOnElement);
        BufferedInputStream bis = this.getBufferedInputStream(filePath);
        XMLIterator xmlIterator = new XMLIterator(splitOnElement, bis);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(xmlIterator, 16), false);
    }

    protected abstract BufferedInputStream getBufferedInputStream(Path var1) throws CollectorException;

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }
}

