/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.createunresolvedentities;

import eu.dnetlib.dhp.actionmanager.Constants;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.PrepareFOSSparkJob;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapGroupsFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSaveUnresolved
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SparkSaveUnresolved.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareFOSSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/produce_unresolved_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Constants.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String sourcePath = parser.get("sourcePath");
        log.info("sourcePath: {}", (Object)sourcePath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> SparkSaveUnresolved.saveUnresolved(spark, sourcePath, outputPath));
    }

    private static void saveUnresolved(SparkSession spark, String sourcePath, String outputPath) {
        spark.read().textFile(sourcePath + "/*").map((MapFunction & Serializable)l -> (Result)Constants.OBJECT_MAPPER.readValue(l, Result.class), Encoders.bean(Result.class)).groupByKey(OafEntity::getId, Encoders.STRING()).mapGroups((MapGroupsFunction & Serializable)(k, it) -> {
            Result ret = (Result)it.next();
            it.forEachRemaining(r -> {
                if (r.getSubject() != null) {
                    if (ret.getSubject() != null) {
                        ret.getSubject().addAll(r.getSubject());
                    } else {
                        ret.setSubject(r.getSubject());
                    }
                }
            });
            return ret;
        }, Encoders.bean(Result.class)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }
}

